/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.record.continuation;

import co.kuali.bai.v2.Bai2ParseException;
import co.kuali.bai.v2.InvalidFieldValueException;
import co.kuali.bai.v2.domain.RecordCode;
import co.kuali.bai.v2.record.Record;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class ContinuationRecord
implements Record {
    private static final int INDEX_NEXT_FIELD = 1;
    private final String recordString;
    private final String[] fields;

    private ContinuationRecord(String recordString) {
        this.recordString = recordString;
        this.fields = recordString.split(",", 2);
        this.validateRecordCode();
        this.validateNumberOfFields();
    }

    private void validateNumberOfFields() {
        int minimumNumberOfFields = 2;
        if (this.fields.length < 2 || StringUtils.isEmpty((CharSequence)this.fields[1]) || StringUtils.equals((CharSequence)"/", (CharSequence)this.fields[1])) {
            throw new Bai2ParseException("Incorrect number of fields (%s) for record; expected at least %s -- %s".formatted(this.fields.length, 2, this.recordString));
        }
    }

    private void validateRecordCode() {
        String recordCode = this.fields[0];
        if (!this.getRecordCode().getCode().equals(recordCode)) {
            throw new InvalidFieldValueException("%s must be " + this.getRecordCode().getCode() + ": %s", "recordCode", recordCode);
        }
    }

    public static ContinuationRecord create(String recordString) {
        return new ContinuationRecord(recordString);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContinuationRecord)) {
            return false;
        }
        ContinuationRecord that = (ContinuationRecord)obj;
        return Objects.equals(this.recordString, that.recordString);
    }

    public int hashCode() {
        return Objects.hash(this.recordString);
    }

    public String toString() {
        return "ContinuationRecord{recordString='" + this.recordString + "'}";
    }

    @Override
    public RecordCode getRecordCode() {
        return RecordCode.CONTINUATION;
    }

    public String getAdditionalFields() {
        return this.fields[1];
    }
}

