/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.record.file;

import co.kuali.bai.v2.InvalidFieldValueException;
import co.kuali.bai.v2.domain.RecordCode;
import co.kuali.bai.v2.record.AbstractRecord;
import co.kuali.bai.v2.record.ValueUtils;
import co.kuali.bai.v2.record.continuation.ContinuationRecord;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public final class FileHeaderRecord
extends AbstractRecord {
    private static final String BAI_VERSION = "2";
    private static final int INDEX_SENDER_IDENTIFICATION = 1;
    private static final int INDEX_RECEIVER_IDENTIFICATION = 2;
    private static final int INDEX_CREATION_DATE = 3;
    private static final int INDEX_CREATION_TIME = 4;
    private static final int INDEX_FILE_IDENTIFICATION_NUMBER = 5;
    private static final int INDEX_PHYSICAL_RECORD_LENGTH = 6;
    private static final int INDEX_BLOCK_SIZE = 7;
    private final String senderIdentification;
    private final String receiverIdentification;
    private final LocalDate creationDate;
    private final LocalTime creationTime;
    private final int fileIdentificationNumber;
    private final @Nullable Long physicalRecordLength;
    private final @Nullable Long blockSize;

    private FileHeaderRecord(String recordString, ContinuationRecord ... continuationRecords) {
        super(recordString, continuationRecords);
        this.senderIdentification = ValueUtils.requiredValueIsAlphanumericHyphenUnderscore("senderIdentification", this.fields[1]);
        this.receiverIdentification = ValueUtils.requiredValueIsAlphanumericHyphenUnderscore("receiverIdentification", this.fields[2]);
        this.creationDate = ValueUtils.requiredValueIsLocalDate("creationDate", this.fields[3]);
        this.creationTime = ValueUtils.requiredValueIsLocalTime("creationTime", this.fields[4]);
        this.fileIdentificationNumber = ValueUtils.requiredValueIsNonNegativeInteger("fileIdentificationNumber", this.fields[5]);
        this.physicalRecordLength = ValueUtils.optionalValueIsPositiveLong("physicalRecordLength", this.fields[6]);
        this.blockSize = ValueUtils.optionalValueIsPositiveLong("blockSize", this.fields[7]);
    }

    public static FileHeaderRecord create(String recordString, ContinuationRecord ... continuationRecords) {
        return new FileHeaderRecord(recordString, continuationRecords);
    }

    @Override
    protected void recordSpecificValidation() {
        String fieldValue = this.fields[8];
        if (!BAI_VERSION.equals(fieldValue)) {
            throw new InvalidFieldValueException("%s is not as expected (2): %s", "version", fieldValue);
        }
    }

    @Override
    public int expectedNumberOfFields(String[] localFields) {
        return 9;
    }

    @Override
    public Map<String, Integer> getRequiredFieldsNameToIndexMapping() {
        return Map.ofEntries(Map.entry("recordCode", 0), Map.entry("senderIdentification", 1), Map.entry("receiverIdentification", 2), Map.entry("creationDate", 3), Map.entry("creationTime", 4), Map.entry("fileIdentificationNumber", 5));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileHeaderRecord)) {
            return false;
        }
        FileHeaderRecord that = (FileHeaderRecord)obj;
        return Objects.equals(this.senderIdentification, that.senderIdentification) && Objects.equals(this.receiverIdentification, that.receiverIdentification) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.creationTime, that.creationTime) && this.fileIdentificationNumber == that.fileIdentificationNumber && Objects.equals(this.physicalRecordLength, that.physicalRecordLength) && Objects.equals(this.blockSize, that.blockSize);
    }

    public int hashCode() {
        return Objects.hash(this.senderIdentification, this.receiverIdentification, this.creationDate, this.creationTime, this.fileIdentificationNumber, this.physicalRecordLength, this.blockSize);
    }

    public String toString() {
        return "FileHeaderRecord{senderIdentification='" + this.senderIdentification + "', receiverIdentification='" + this.receiverIdentification + "', creationDate=" + String.valueOf(this.creationDate) + ", creationTime=" + String.valueOf(this.creationTime) + ", fileIdentificationNumber=" + this.fileIdentificationNumber + ", physicalRecordLength=" + this.physicalRecordLength + ", blockSize=" + this.blockSize + "}";
    }

    @Override
    public RecordCode getRecordCode() {
        return RecordCode.FILE_HEADER;
    }

    public String getSenderIdentification() {
        return this.senderIdentification;
    }

    public String getReceiverIdentification() {
        return this.receiverIdentification;
    }

    public LocalDate getCreationDate() {
        return this.creationDate;
    }

    public LocalTime getCreationTime() {
        return this.creationTime;
    }

    public int getFileIdentificationNumber() {
        return this.fileIdentificationNumber;
    }

    public @Nullable Long getPhysicalRecordLength() {
        return this.physicalRecordLength;
    }

    public @Nullable Long getBlockSize() {
        return this.blockSize;
    }
}

