/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.record.file;

import co.kuali.bai.v2.domain.RecordCode;
import co.kuali.bai.v2.record.AbstractRecord;
import co.kuali.bai.v2.record.ValueUtils;
import co.kuali.bai.v2.record.continuation.ContinuationRecord;
import java.util.Map;
import java.util.Objects;

public final class FileTrailerRecord
extends AbstractRecord {
    private static final int INDEX_FILE_CONTROL_TOTAL = 1;
    private static final int INDEX_NUMBER_OF_GROUPS = 2;
    private static final int INDEX_NUMBER_OF_RECORDS = 3;
    private final long fileControlTotal;
    private final long numberOfGroups;
    private final long numberOfRecords;

    private FileTrailerRecord(String recordString, ContinuationRecord ... continuationRecords) {
        super(recordString, continuationRecords);
        this.fileControlTotal = ValueUtils.requiredValueIsLong("fileControlTotal", this.fields[1]);
        this.numberOfGroups = ValueUtils.requiredValueIsPositiveLong("numberOfGroups", this.fields[2]);
        this.numberOfRecords = ValueUtils.requiredValueIsPositiveLong("numberOfRecords", this.fields[3]);
    }

    public static FileTrailerRecord create(String recordString, ContinuationRecord ... continuationRecords) {
        return new FileTrailerRecord(recordString, continuationRecords);
    }

    @Override
    public int expectedNumberOfFields(String[] localFields) {
        return 4;
    }

    @Override
    public Map<String, Integer> getRequiredFieldsNameToIndexMapping() {
        return Map.ofEntries(Map.entry("recordCode", 0), Map.entry("fileControlTotal", 1), Map.entry("numberOfGroups", 2), Map.entry("numberOfRecords", 3));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileTrailerRecord)) {
            return false;
        }
        FileTrailerRecord that = (FileTrailerRecord)obj;
        return this.fileControlTotal == that.fileControlTotal && this.numberOfGroups == that.numberOfGroups && this.numberOfRecords == that.numberOfRecords;
    }

    public int hashCode() {
        return Objects.hash(this.fileControlTotal, this.numberOfGroups, this.numberOfRecords);
    }

    public String toString() {
        return "FileTrailerRecord{fileControlTotal=" + this.fileControlTotal + ", numberOfGroups=" + this.numberOfGroups + ", numberOfRecords=" + this.numberOfRecords + "}";
    }

    @Override
    public RecordCode getRecordCode() {
        return RecordCode.FILE_TRAILER;
    }

    public long getFileControlTotal() {
        return this.fileControlTotal;
    }

    public long getNumberOfGroups() {
        return this.numberOfGroups;
    }

    public long getNumberOfRecords() {
        return this.numberOfRecords;
    }
}

