/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.record.fundsavailability;

import co.kuali.bai.v2.Bai2ParseException;
import co.kuali.bai.v2.domain.FundsType;
import co.kuali.bai.v2.record.ValueUtils;
import co.kuali.bai.v2.record.fundsavailability.FundsAvailabilitySubRecord;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class DistributedDetailedSubRecord
implements FundsAvailabilitySubRecord {
    private final int numberOfDistributions;
    private final Map<Integer, Long> dayAndAmountMappings = new HashMap<Integer, Long>();

    private DistributedDetailedSubRecord(Map<Integer, Long> dayAndAmountMappings) {
        this.numberOfDistributions = dayAndAmountMappings.size();
        this.dayAndAmountMappings.putAll(dayAndAmountMappings);
    }

    static DistributedDetailedSubRecord create(int index, String[] fields) {
        if (fields.length == 0) {
            throw new Bai2ParseException("Not enough fields to parse a DistributedDetailedSubRecord; expected at least 3 but was " + fields.length);
        }
        int numberOfDistributions = ValueUtils.requiredValueIsPositiveInteger("numberOfDistributions", fields[index]);
        int numberOfFieldsEncompassed = 1 + 2 * numberOfDistributions;
        if (fields.length < numberOfFieldsEncompassed) {
            throw new Bai2ParseException("Not enough fields to parse a DistributedDetailedSubRecord; expected " + numberOfFieldsEncompassed + " but was " + fields.length);
        }
        HashMap<Integer, Long> dayAndAmountMappings = new HashMap<Integer, Long>();
        for (int i = 0; i < numberOfDistributions; ++i) {
            int distributionOffset = 2 * i;
            int dayIndex = index + 1 + distributionOffset;
            int day = ValueUtils.requiredValueIsNonNegativeInteger("distributionDays(" + i + ")", fields[dayIndex]);
            int amountIndex = dayIndex + 1;
            long amount = ValueUtils.requiredValueIsPositiveLong("distributionAmount(" + i + ")", fields[amountIndex]);
            dayAndAmountMappings.put(day, amount);
        }
        return new DistributedDetailedSubRecord(dayAndAmountMappings);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DistributedDetailedSubRecord)) {
            return false;
        }
        DistributedDetailedSubRecord that = (DistributedDetailedSubRecord)obj;
        return this.numberOfDistributions == that.numberOfDistributions && Objects.equals(this.dayAndAmountMappings, that.dayAndAmountMappings);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfDistributions, this.dayAndAmountMappings);
    }

    public String toString() {
        return "DistributedDetailedSubRecord{numberOfDistributions=" + this.numberOfDistributions + ", dayAndAmountMappings=" + String.valueOf(this.dayAndAmountMappings) + "}";
    }

    @Override
    public FundsType getFundsType() {
        return FundsType.DETAILED_DISTRIBUTED_AVAILABILITY;
    }

    @Override
    public int numberOfFieldsEncompassed() {
        return 1 + 2 * this.numberOfDistributions;
    }

    public Map<Integer, Long> getDayAndAmountMappings() {
        return Map.copyOf(this.dayAndAmountMappings);
    }
}

