/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.record.fundsavailability;

import co.kuali.bai.v2.Bai2ParseException;
import co.kuali.bai.v2.domain.FundsType;
import co.kuali.bai.v2.record.ValueUtils;
import co.kuali.bai.v2.record.fundsavailability.FundsAvailabilitySubRecord;
import java.util.Objects;

public final class DistributedSimpleSubRecord
implements FundsAvailabilitySubRecord {
    private static final int NUMBER_OF_FIELDS_ENCOMPASSED = 3;
    private final long immediateAvailabilityAmount;
    private final long oneDayAvailabilityAmount;
    private final long moreThanOneDayAvailabilityAmount;

    private DistributedSimpleSubRecord(long immediateAvailabilityAmount, long oneDayAvailabilityAmount, long moreThanOneDayAvailabilityAmount) {
        this.immediateAvailabilityAmount = immediateAvailabilityAmount;
        this.oneDayAvailabilityAmount = oneDayAvailabilityAmount;
        this.moreThanOneDayAvailabilityAmount = moreThanOneDayAvailabilityAmount;
    }

    static DistributedSimpleSubRecord create(int index, String[] fields) {
        if (fields.length < 3) {
            throw new Bai2ParseException("Not enough fields to parse a DistributedSimpleSubRecord; expected 3 but was " + fields.length);
        }
        long immediateAvailabilityAmount = ValueUtils.requiredValueIsNonNegativeLong("immediateAvailabilityAmount", fields[index]);
        long oneDayAvailabilityAmount = ValueUtils.requiredValueIsNonNegativeLong("oneDayAvailabilityAmount", fields[index + 1]);
        long moreThanOneDayAvailabilityAmount = ValueUtils.requiredValueIsNonNegativeLong("moreThanOneDayAvailabilityAmount", fields[index + 2]);
        return new DistributedSimpleSubRecord(immediateAvailabilityAmount, oneDayAvailabilityAmount, moreThanOneDayAvailabilityAmount);
    }

    @Override
    public int numberOfFieldsEncompassed() {
        return 3;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DistributedSimpleSubRecord)) {
            return false;
        }
        DistributedSimpleSubRecord that = (DistributedSimpleSubRecord)obj;
        return this.immediateAvailabilityAmount == that.immediateAvailabilityAmount && this.oneDayAvailabilityAmount == that.oneDayAvailabilityAmount && this.moreThanOneDayAvailabilityAmount == that.moreThanOneDayAvailabilityAmount;
    }

    public int hashCode() {
        return Objects.hash(this.immediateAvailabilityAmount, this.oneDayAvailabilityAmount, this.moreThanOneDayAvailabilityAmount);
    }

    public String toString() {
        return "DistributedSimpleSubRecord{immediateAvailabilityAmount=" + this.immediateAvailabilityAmount + ", oneDayAvailabilityAmount=" + this.oneDayAvailabilityAmount + ", moreThanOneDayAvailabilityAmount=" + this.moreThanOneDayAvailabilityAmount + "}";
    }

    @Override
    public FundsType getFundsType() {
        return FundsType.SIMPLE_DISTRIBUTED_AVAILABILITY;
    }

    public long getImmediateAvailabilityAmount() {
        return this.immediateAvailabilityAmount;
    }

    public long getOneDayAvailabilityAmount() {
        return this.oneDayAvailabilityAmount;
    }

    public long getMoreThanOneDayAvailabilityAmount() {
        return this.moreThanOneDayAvailabilityAmount;
    }
}

