/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.record.fundsavailability;

import co.kuali.bai.v2.domain.FundsType;
import co.kuali.bai.v2.record.fundsavailability.DistributedDetailedSubRecord;
import co.kuali.bai.v2.record.fundsavailability.DistributedSimpleSubRecord;
import co.kuali.bai.v2.record.fundsavailability.FundsAvailabilitySubRecord;
import co.kuali.bai.v2.record.fundsavailability.SimpleSubRecord;
import co.kuali.bai.v2.record.fundsavailability.ValueDatedSubRecord;

public final class FundsAvailabilitySubRecordFactory {
    private static final SimpleSubRecord IMMEDIATE_AVAILABILITY_DISTRIBUTION = new SimpleSubRecord(FundsType.IMMEDIATE_AVAILABILITY);
    private static final SimpleSubRecord ONE_DAY_AVAILABILITY_DISTRIBUTION = new SimpleSubRecord(FundsType.ONE_DAY_AVAILABILITY);
    private static final SimpleSubRecord TWO_OR_MORE_DAYS_AVAILABILITY_DISTRIBUTION = new SimpleSubRecord(FundsType.TWO_OR_MORE_DAYS_AVAILABILITY);
    private static final SimpleSubRecord UNKNOWN_DISTRIBUTION = new SimpleSubRecord(FundsType.UNKNOWN);

    private FundsAvailabilitySubRecordFactory() {
    }

    public static FundsAvailabilitySubRecord create(FundsType fundsType, int index, String[] fields) {
        return switch (fundsType) {
            case FundsType.IMMEDIATE_AVAILABILITY -> IMMEDIATE_AVAILABILITY_DISTRIBUTION;
            case FundsType.ONE_DAY_AVAILABILITY -> ONE_DAY_AVAILABILITY_DISTRIBUTION;
            case FundsType.TWO_OR_MORE_DAYS_AVAILABILITY -> TWO_OR_MORE_DAYS_AVAILABILITY_DISTRIBUTION;
            case FundsType.SIMPLE_DISTRIBUTED_AVAILABILITY -> DistributedSimpleSubRecord.create(index, fields);
            case FundsType.VALUE_DATED -> ValueDatedSubRecord.create(index, fields);
            case FundsType.DETAILED_DISTRIBUTED_AVAILABILITY -> DistributedDetailedSubRecord.create(index, fields);
            case FundsType.UNKNOWN -> UNKNOWN_DISTRIBUTION;
            default -> throw new IllegalArgumentException("Unknown funds type: " + String.valueOf((Object)fundsType));
        };
    }
}

