/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.record.fundsavailability;

import co.kuali.bai.v2.InvalidFieldValueException;
import co.kuali.bai.v2.domain.FundsType;
import co.kuali.bai.v2.record.fundsavailability.FundsAvailabilitySubRecord;
import java.util.List;
import java.util.Objects;

public final class SimpleSubRecord
implements FundsAvailabilitySubRecord {
    private static final List<FundsType> ALLOWABLE_CODES = List.of(FundsType.IMMEDIATE_AVAILABILITY, FundsType.ONE_DAY_AVAILABILITY, FundsType.TWO_OR_MORE_DAYS_AVAILABILITY, FundsType.UNKNOWN);
    private final FundsType fundsType;

    public SimpleSubRecord(FundsType fundsType) {
        if (!ALLOWABLE_CODES.contains((Object)fundsType)) {
            throw new InvalidFieldValueException("%s must be an allowable code (0, 1, 2, Z): %s", "fundsType", fundsType.getCode());
        }
        this.fundsType = fundsType;
    }

    @Override
    public int numberOfFieldsEncompassed() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleSubRecord)) {
            return false;
        }
        SimpleSubRecord that = (SimpleSubRecord)obj;
        return this.fundsType == that.fundsType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fundsType});
    }

    public String toString() {
        return "SimpleSubRecord{fundsType='" + String.valueOf((Object)this.fundsType) + "'}";
    }

    @Override
    public FundsType getFundsType() {
        return this.fundsType;
    }
}

