/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.record.fundsavailability;

import co.kuali.bai.v2.Bai2ParseException;
import co.kuali.bai.v2.domain.FundsType;
import co.kuali.bai.v2.record.ValueUtils;
import co.kuali.bai.v2.record.fundsavailability.FundsAvailabilitySubRecord;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public final class ValueDatedSubRecord
implements FundsAvailabilitySubRecord {
    private static final int NUMBER_OF_FIELDS_ENCOMPASSED = 2;
    private final LocalDate valueDate;
    private final @Nullable LocalTime valueTime;

    private ValueDatedSubRecord(LocalDate valueDate, @Nullable LocalTime valueTime) {
        this.valueDate = valueDate;
        this.valueTime = valueTime;
    }

    static ValueDatedSubRecord create(int index, String[] fields) {
        if (fields.length < 2) {
            throw new Bai2ParseException("Not enough fields to parse a ValueDatedSubRecord; expected 2 but was " + fields.length);
        }
        LocalDate valueDate = ValueUtils.requiredValueIsLocalDate("valueDate", fields[index]);
        LocalTime valueTime = ValueUtils.optionalValueIsLocalTime("valueTime", fields[index + 1]);
        return new ValueDatedSubRecord(valueDate, valueTime);
    }

    @Override
    public int numberOfFieldsEncompassed() {
        return 2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ValueDatedSubRecord)) {
            return false;
        }
        ValueDatedSubRecord that = (ValueDatedSubRecord)obj;
        return Objects.equals(this.valueDate, that.valueDate) && Objects.equals(this.valueTime, that.valueTime);
    }

    public int hashCode() {
        return Objects.hash(this.valueDate, this.valueTime);
    }

    public String toString() {
        return "ValueDatedSubRecord{valueDate=" + String.valueOf(this.valueDate) + ", valueTime=" + String.valueOf(this.valueTime) + "}";
    }

    @Override
    public FundsType getFundsType() {
        return FundsType.VALUE_DATED;
    }

    public LocalDate getValueDate() {
        return this.valueDate;
    }

    public @Nullable LocalTime getValueTime() {
        return this.valueTime;
    }
}

