/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.record.group;

import co.kuali.bai.v2.domain.AsOfDateModifier;
import co.kuali.bai.v2.domain.GroupStatus;
import co.kuali.bai.v2.domain.RecordCode;
import co.kuali.bai.v2.record.AbstractRecord;
import co.kuali.bai.v2.record.ValueUtils;
import co.kuali.bai.v2.record.continuation.ContinuationRecord;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Currency;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public final class GroupHeaderRecord
extends AbstractRecord {
    private static final int INDEX_ULTIMATE_RECEIVER_IDENTIFICATION = 1;
    private static final int INDEX_ORIGINATOR_IDENTIFICATION = 2;
    private static final int INDEX_GROUP_STATUS = 3;
    private static final int INDEX_AS_OF_DATE = 4;
    private static final int INDEX_AS_OF_TIME = 5;
    private static final int INDEX_CURRENCY_CODE = 6;
    private static final int INDEX_AS_OF_DATE_MODIFIER = 7;
    private final @Nullable String ultimateReceiverIdentification;
    private final String originatorIdentification;
    private final GroupStatus groupStatus;
    private final LocalDate asOfDate;
    private final @Nullable LocalTime asOfTime;
    private final @Nullable Currency currency;
    private final @Nullable AsOfDateModifier asOfDateModifier;

    private GroupHeaderRecord(String recordString, ContinuationRecord ... continuationRecords) {
        super(recordString, continuationRecords);
        this.ultimateReceiverIdentification = ValueUtils.optionalValueIsAlphanumeric("ultimateReceiverIdentification", this.fields[1]);
        this.originatorIdentification = ValueUtils.requiredValueIsAlphanumericHyphenUnderscore("originatorIdentification", this.fields[2]);
        this.groupStatus = GroupStatus.get(this.fields[3]);
        this.asOfDate = ValueUtils.requiredValueIsLocalDate("asOfDate", this.fields[4]);
        this.asOfTime = ValueUtils.optionalValueIsLocalTime("asOfTime", this.fields[5]);
        this.currency = ValueUtils.optionalValueIsCurrency("currencyCode", this.fields[6]);
        this.asOfDateModifier = GroupHeaderRecord.optionalValueIsAsOfDateModifier(this.fields[7]);
    }

    public static GroupHeaderRecord create(String recordString, ContinuationRecord ... continuationRecords) {
        return new GroupHeaderRecord(recordString, continuationRecords);
    }

    private static @Nullable AsOfDateModifier optionalValueIsAsOfDateModifier(String fieldValue) {
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            return null;
        }
        return AsOfDateModifier.get(fieldValue);
    }

    @Override
    public int expectedNumberOfFields(String[] localFields) {
        return 8;
    }

    @Override
    public Map<String, Integer> getRequiredFieldsNameToIndexMapping() {
        return Map.ofEntries(Map.entry("recordCode", 0), Map.entry("originatorIdentification", 2), Map.entry("groupStatus", 3), Map.entry("asOfDate", 4));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GroupHeaderRecord)) {
            return false;
        }
        GroupHeaderRecord that = (GroupHeaderRecord)obj;
        return Objects.equals(this.ultimateReceiverIdentification, that.ultimateReceiverIdentification) && Objects.equals(this.originatorIdentification, that.originatorIdentification) && this.groupStatus == that.groupStatus && Objects.equals(this.asOfDate, that.asOfDate) && Objects.equals(this.asOfTime, that.asOfTime) && this.currency == that.currency && this.asOfDateModifier == that.asOfDateModifier;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ultimateReceiverIdentification, this.originatorIdentification, this.groupStatus, this.asOfDate, this.asOfTime, this.currency, this.asOfDateModifier});
    }

    public String toString() {
        return "GroupHeaderRecord{ultimateReceiverIdentification='" + this.ultimateReceiverIdentification + "', originatorIdentification='" + this.originatorIdentification + "', groupStatus=" + String.valueOf((Object)this.groupStatus) + ", asOfDate=" + String.valueOf(this.asOfDate) + ", asOfTime=" + String.valueOf(this.asOfTime) + ", currencyCode=" + String.valueOf(this.currency) + ", asOfDateModifier=" + String.valueOf((Object)this.asOfDateModifier) + "}";
    }

    @Override
    public RecordCode getRecordCode() {
        return RecordCode.GROUP_HEADER;
    }

    public @Nullable String getUltimateReceiverIdentification() {
        return this.ultimateReceiverIdentification;
    }

    public String getOriginatorIdentification() {
        return this.originatorIdentification;
    }

    public GroupStatus getGroupStatus() {
        return this.groupStatus;
    }

    public LocalDate getAsOfDate() {
        return this.asOfDate;
    }

    public @Nullable LocalTime getAsOfTime() {
        return this.asOfTime;
    }

    public @Nullable Currency getCurrency() {
        return this.currency;
    }

    public @Nullable AsOfDateModifier getAsOfDateModifier() {
        return this.asOfDateModifier;
    }
}

