/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.record.group;

import co.kuali.bai.v2.domain.RecordCode;
import co.kuali.bai.v2.record.AbstractRecord;
import co.kuali.bai.v2.record.ValueUtils;
import co.kuali.bai.v2.record.continuation.ContinuationRecord;
import java.util.Map;
import java.util.Objects;

public final class GroupTrailerRecord
extends AbstractRecord {
    private static final int INDEX_GROUP_CONTROL_TOTAL = 1;
    private static final int INDEX_NUMBER_OF_ACCOUNTS = 2;
    private static final int INDEX_NUMBER_OF_RECORDS = 3;
    private final long groupControlTotal;
    private final int numberOfAccounts;
    private final int numberOfRecords;

    private GroupTrailerRecord(String recordString, ContinuationRecord ... continuationRecords) {
        super(recordString, continuationRecords);
        this.groupControlTotal = ValueUtils.requiredValueIsLong("groupControlTotal", this.fields[1]);
        this.numberOfAccounts = ValueUtils.requiredValueIsPositiveInteger("numberOfAccounts", this.fields[2]);
        this.numberOfRecords = ValueUtils.requiredValueIsPositiveInteger("numberOfRecords", this.fields[3]);
    }

    public static GroupTrailerRecord create(String recordString, ContinuationRecord ... continuationRecords) {
        return new GroupTrailerRecord(recordString, continuationRecords);
    }

    @Override
    public int expectedNumberOfFields(String[] localFields) {
        return 4;
    }

    @Override
    public Map<String, Integer> getRequiredFieldsNameToIndexMapping() {
        return Map.ofEntries(Map.entry("recordCode", 0), Map.entry("groupControlTotal", 1), Map.entry("numberOfAccounts", 2), Map.entry("numberOfRecords", 3));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GroupTrailerRecord)) {
            return false;
        }
        GroupTrailerRecord that = (GroupTrailerRecord)obj;
        return this.groupControlTotal == that.groupControlTotal && this.numberOfAccounts == that.numberOfAccounts && this.numberOfRecords == that.numberOfRecords;
    }

    public int hashCode() {
        return Objects.hash(this.groupControlTotal, this.numberOfAccounts, this.numberOfRecords);
    }

    public String toString() {
        return "GroupTrailerRecord{groupControlTotal=" + this.groupControlTotal + ", numberOfAccounts=" + this.numberOfAccounts + ", numberOfRecords=" + this.numberOfRecords + "}";
    }

    @Override
    public RecordCode getRecordCode() {
        return RecordCode.GROUP_TRAILER;
    }

    public long getGroupControlTotal() {
        return this.groupControlTotal;
    }

    public int getNumberOfAccounts() {
        return this.numberOfAccounts;
    }

    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }
}

