/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.record.transaction;

import co.kuali.bai.v2.InvalidFieldValueException;
import co.kuali.bai.v2.domain.FundsType;
import co.kuali.bai.v2.domain.RecordCode;
import co.kuali.bai.v2.domain.TypeCode;
import co.kuali.bai.v2.record.AbstractRecord;
import co.kuali.bai.v2.record.ValueUtils;
import co.kuali.bai.v2.record.continuation.ContinuationRecord;
import co.kuali.bai.v2.record.fundsavailability.FundsAvailabilitySubRecord;
import co.kuali.bai.v2.record.fundsavailability.FundsAvailabilitySubRecordFactory;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public final class TransactionDetailRecord
extends AbstractRecord {
    private final TypeCode typeCode;
    private final @Nullable Long amount;
    private final @Nullable FundsAvailabilitySubRecord fundsAvailabilitySubRecord;
    private final @Nullable String bankReferenceNumber;
    private final @Nullable String customerReferenceNumber;
    private final @Nullable String text;

    private TransactionDetailRecord(String recordString, ContinuationRecord ... continuationRecords) {
        super(recordString, continuationRecords);
        int index = 1;
        this.typeCode = TransactionDetailRecord.requiredValueIsDetailTypeCode(this.fields[index++]);
        if (TypeCode.NON_MONETARY_DETAIL_INFO == this.typeCode) {
            ValueUtils.valueIsNotProvided("amount", this.fields[index++]);
            ValueUtils.valueIsNotProvided("fundsType", this.fields[index++]);
            this.amount = null;
            this.fundsAvailabilitySubRecord = null;
        } else {
            FundsType fundsType;
            this.amount = ValueUtils.optionalValueIsNonNegativeLong("amount", this.fields[index++]);
            if ((fundsType = ValueUtils.optionalValueIsFundsType(this.fields[index++])) == null) {
                this.fundsAvailabilitySubRecord = null;
            } else {
                this.fundsAvailabilitySubRecord = FundsAvailabilitySubRecordFactory.create(fundsType, index, this.fields);
                index += this.fundsAvailabilitySubRecord.numberOfFieldsEncompassed();
            }
        }
        this.bankReferenceNumber = ValueUtils.optionalValueIsAlphanumericHyphenUnderscore("bankReferenceNumber", this.fields[index++]);
        this.customerReferenceNumber = ValueUtils.optionalValueIsCustomerReference("customerReferenceNumber", this.fields[index++]);
        this.text = ValueUtils.optionalValueIsText("text", this.fields[index]);
    }

    @Override
    protected String unify(String primaryRecordString, ContinuationRecord ... continuationRecords) {
        if (ArrayUtils.isEmpty((Object[])continuationRecords)) {
            return primaryRecordString;
        }
        BiPredicate<Integer, Integer> priorToText = (actual, expected) -> actual >= expected;
        boolean theTextFieldHasBeenReached = TransactionDetailRecord.checkIfWeAreInTheTextField(primaryRecordString, priorToText);
        if (!theTextFieldHasBeenReached) {
            TransactionDetailRecord.validateLineTermination(primaryRecordString);
        }
        String primaryRecordStringWithoutTerminatingSlash = StringUtils.removeEnd((String)primaryRecordString, (String)"/");
        StringBuilder unifiedRecordString = new StringBuilder(primaryRecordStringWithoutTerminatingSlash);
        for (ContinuationRecord continuationRecord : continuationRecords) {
            String additionalFields = continuationRecord.getAdditionalFields();
            BiPredicate<Integer, Integer> continuingText = (actual, expected) -> actual >= expected - 2;
            boolean continuationIsText = TransactionDetailRecord.checkIfWeAreInTheTextField(unifiedRecordString.toString(), continuingText);
            if (!theTextFieldHasBeenReached && !continuationIsText) {
                TransactionDetailRecord.validateLineTermination(additionalFields);
            }
            String additionalFieldStringWithoutTerminatingSlash = StringUtils.removeEnd((String)additionalFields, (String)"/");
            if (!theTextFieldHasBeenReached) {
                unifiedRecordString.append(",");
            }
            unifiedRecordString.append(additionalFieldStringWithoutTerminatingSlash);
            if (theTextFieldHasBeenReached) continue;
            theTextFieldHasBeenReached = TransactionDetailRecord.checkIfWeAreInTheTextField(unifiedRecordString.toString(), priorToText);
        }
        if (!theTextFieldHasBeenReached) {
            unifiedRecordString.append("/");
        }
        return unifiedRecordString.toString();
    }

    private static boolean checkIfWeAreInTheTextField(String primaryRecordString, BiPredicate<Integer, Integer> predicate) {
        int fundsTypeIndex = 3;
        String[] localFields = primaryRecordString.split(",");
        if (localFields.length >= 3) {
            try {
                int expectedNumberOfFields = TransactionDetailRecord.expectedNumberOfFields(localFields, true);
                return predicate.test(localFields.length, expectedNumberOfFields);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected String[] processRecordString() {
        boolean expectedNumberOfFieldsArePresent;
        int expectedNumberOfFields;
        boolean thereAreMoreFieldsThanExpected;
        String[] localFields = this.recordString.split(",", -1);
        boolean bl = thereAreMoreFieldsThanExpected = localFields.length > (expectedNumberOfFields = this.expectedNumberOfFields(localFields));
        if (thereAreMoreFieldsThanExpected) {
            return this.recordString.split(",", expectedNumberOfFields);
        }
        boolean bl2 = expectedNumberOfFieldsArePresent = localFields.length == expectedNumberOfFields;
        if (expectedNumberOfFieldsArePresent) {
            String textField = localFields[localFields.length - 1];
            if (StringUtils.isEmpty((CharSequence)textField)) {
                this.validateSlashTerminatesTheRecord(localFields);
            } else if (StringUtils.equals((CharSequence)textField, (CharSequence)"/")) {
                TransactionDetailRecord.stripTerminatingSlash(localFields);
            }
        }
        return localFields;
    }

    public static TransactionDetailRecord create(String recordString, ContinuationRecord ... continuationRecords) {
        return new TransactionDetailRecord(recordString, continuationRecords);
    }

    private static TypeCode requiredValueIsDetailTypeCode(String fieldValue) {
        TypeCode tc = TypeCode.get(fieldValue);
        if (tc.isDetail()) {
            return tc;
        }
        throw new InvalidFieldValueException("%s must be a Detail TypeCode: %s", "typeCode", fieldValue);
    }

    @Override
    public int expectedNumberOfFields(String[] localFields) {
        return TransactionDetailRecord.expectedNumberOfFields(localFields, false);
    }

    private static int expectedNumberOfFields(String[] localFields, boolean stripTrailingSlashFromFields) {
        String typeCodeField;
        int expectedRecordLength = 7;
        String string = typeCodeField = stripTrailingSlashFromFields ? StringUtils.removeEnd((String)localFields[1], (String)"/") : localFields[1];
        if (TypeCode.NON_MONETARY_DETAIL_INFO.getCode().equals(typeCodeField)) {
            return expectedRecordLength;
        }
        String fundsTypeField = stripTrailingSlashFromFields ? StringUtils.removeEnd((String)localFields[3], (String)"/") : localFields[3];
        FundsType fundsType = ValueUtils.optionalValueIsFundsType(fundsTypeField);
        if (fundsType == FundsType.VALUE_DATED) {
            expectedRecordLength += 2;
        } else if (fundsType == FundsType.SIMPLE_DISTRIBUTED_AVAILABILITY) {
            expectedRecordLength += 3;
        } else if (fundsType == FundsType.DETAILED_DISTRIBUTED_AVAILABILITY) {
            String distributionCountField = stripTrailingSlashFromFields ? StringUtils.removeEnd((String)localFields[4], (String)"/") : localFields[4];
            int distributionCount = ValueUtils.requiredValueIsNonNegativeInteger("distributionCount", distributionCountField);
            int distributionFieldCount = distributionCount * 2;
            expectedRecordLength += 1 + distributionFieldCount;
        }
        return expectedRecordLength;
    }

    @Override
    public Map<String, Integer> getRequiredFieldsNameToIndexMapping() {
        return Map.of("recordCode", 0, "typeCode", 1);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TransactionDetailRecord)) {
            return false;
        }
        TransactionDetailRecord that = (TransactionDetailRecord)obj;
        return Objects.equals(this.amount, that.amount) && this.typeCode == that.typeCode && Objects.equals(this.fundsAvailabilitySubRecord, that.fundsAvailabilitySubRecord) && Objects.equals(this.bankReferenceNumber, that.bankReferenceNumber) && Objects.equals(this.customerReferenceNumber, that.customerReferenceNumber) && Objects.equals(this.text, that.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.typeCode, this.amount, this.fundsAvailabilitySubRecord, this.bankReferenceNumber, this.customerReferenceNumber, this.text});
    }

    public String toString() {
        return "TransactionDetailRecord{typeCode=" + String.valueOf((Object)this.typeCode) + ", amount=" + this.amount + ", fundsAvailabilitySubRecord=" + String.valueOf(this.fundsAvailabilitySubRecord) + ", bankReferenceNumber='" + this.bankReferenceNumber + "', customerReferenceNumber='" + this.customerReferenceNumber + "', text='" + this.text + "'}";
    }

    @Override
    public RecordCode getRecordCode() {
        return RecordCode.TRANSACTION_DETAIL;
    }

    public TypeCode getTypeCode() {
        return this.typeCode;
    }

    public @Nullable Long getAmount() {
        return this.amount;
    }

    public @Nullable FundsAvailabilitySubRecord getFundsAvailability() {
        return this.fundsAvailabilitySubRecord;
    }

    public @Nullable String getBankReferenceNumber() {
        return this.bankReferenceNumber;
    }

    public @Nullable String getCustomerReferenceNumber() {
        return this.customerReferenceNumber;
    }

    public @Nullable String getText() {
        return this.text;
    }
}

