/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.financials.datatools.liquimongo.businessobject;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;
import org.springframework.data.annotation.Transient;

public class DocumentStoreChange {
    private static final Logger LOG = Logger.getLogger(DocumentStoreChange.class);
    private String fileName;
    private Date changeDate = new Date();
    private String changeId;
    private String hash;
    @Transient
    private JsonNode changeNode;

    public DocumentStoreChange() {
    }

    public DocumentStoreChange(String fileName, JsonNode node) {
        this();
        this.fileName = fileName;
        this.changeNode = node;
        this.changeId = node.get("id").asText();
        this.hash = this.calculateHash();
    }

    private String calculateHash() {
        try {
            byte[] bytesOfMessage = this.changeNode.toString().getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] md5hash = md.digest(bytesOfMessage);
            return Hex.encodeHexString((byte[])md5hash);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            LOG.error((Object)"calculateHash() Unable to md5 hash", (Throwable)e);
            throw new UnsupportedOperationException("Unable to hash change");
        }
    }

    public List<JsonNode> getAllChanges() {
        ArrayList<JsonNode> changeList = new ArrayList<JsonNode>();
        JsonNode changes = this.changeNode.get("changes");
        Iterator items = changes.elements();
        while (items.hasNext()) {
            changeList.add((JsonNode)items.next());
        }
        return changeList;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Date getChangeDate() {
        return this.changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public String getChangeId() {
        return this.changeId;
    }

    public void setChangeId(String changeId) {
        this.changeId = changeId;
    }

    public JsonNode getChangeNode() {
        return this.changeNode;
    }

    public void setChangeNode(JsonNode changeNode) {
        this.changeNode = changeNode;
    }

    public String toString() {
        return "DocumentStoreChange{changeId='" + this.changeId + '\'' + ", fileName='" + this.fileName + '\'' + ", changeDate=" + this.changeDate + ", hash=" + this.hash + '}';
    }
}

