/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.financials.datatools.liquirelational;

import co.kuali.financials.datatools.util.PropertyLoadingFactoryBean;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;

public class LiquiRelational {
    private static final Logger LOG = Logger.getLogger(LiquiRelational.class);
    protected static final String UPDATE_DATABASE_FULL_REBUILD = "updateDatabaseFullRebuild";
    protected static final String UPDATE_DATABASE_CONTEXT = "updateDatabaseContext";
    protected static final String UPDATE_DATABASE_PACKAGES = "updateDatabasePackages";
    protected static final String UPDATE_DATABASE_PACKAGES_RICE = "updateDatabasePackagesRice";
    private ClassPathXmlApplicationContext applicationContext;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        LiquiRelational liquiRelational = new LiquiRelational();
        liquiRelational.updateDatabase();
        System.exit(0);
    }

    public void updateDatabase() {
        this.initializeContext();
        this.applyUpdates();
        this.applicationContext.close();
    }

    private void initializeContext() {
        long startInit = System.currentTimeMillis();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Initializing LiquiRelational Context...");
        }
        this.applicationContext = new ClassPathXmlApplicationContext("co/kuali/financials/datatools/liquirelational/kfs-liqui-relational-bootstrap.xml");
        this.applicationContext.start();
        long endInit = System.currentTimeMillis();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("...LiquiRelational Context successfully initialized, startup took " + (endInit - startInit) + " ms."));
        }
    }

    private void applyUpdates() {
        this.applyDatabaseUpdates("dataSource", UPDATE_DATABASE_PACKAGES);
        this.applyDatabaseUpdates("riceDataSource", UPDATE_DATABASE_PACKAGES_RICE);
    }

    private void applyDatabaseUpdates(String dataSource, String databaseUpdatePackages) {
        DataSource kfsDataSource = (DataSource)this.applicationContext.getBean(dataSource, DataSource.class);
        List<String> packages = PropertyLoadingFactoryBean.getBaseListProperty(databaseUpdatePackages);
        if (this.isEmptyList(packages)) {
            LOG.info((Object)(databaseUpdatePackages + " property is empty, nothing to update."));
        } else {
            this.updateDatabase(kfsDataSource, packages);
        }
    }

    private boolean isEmptyList(List<String> packages) {
        if (CollectionUtils.isEmpty(packages)) {
            return true;
        }
        for (String pkg : packages) {
            if (!StringUtils.isNotBlank((String)pkg)) continue;
            return false;
        }
        return true;
    }

    private void updateDatabase(DataSource dataSource, List<String> packages) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
            ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(this.applicationContext.getClassLoader());
            String liquibaseContext = PropertyLoadingFactoryBean.getBaseProperty(UPDATE_DATABASE_CONTEXT);
            this.runUpdatesPhase(database, (ResourceAccessor)resourceAccessor, liquibaseContext, packages);
        }
        catch (SQLException | DatabaseException e) {
            LOG.error((Object)"Failed to get datasource.", e);
            throw new RuntimeException(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Failed to get close connection.", (Throwable)e);
                    connection = null;
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void runUpdatesPhase(Database database, ResourceAccessor resourceAccessor, String liquibaseContext, List<String> packages) {
        ArrayList<String> phaseFilenames = new ArrayList<String>();
        if (Boolean.parseBoolean(PropertyLoadingFactoryBean.getBaseProperty(UPDATE_DATABASE_FULL_REBUILD))) {
            for (int i = 1; i < 5; ++i) {
                phaseFilenames.addAll(this.findFilenamesForPhase(i, packages));
            }
        }
        phaseFilenames.addAll(this.findFilenamesForPhase(5, packages));
        for (String filename : phaseFilenames) {
            try {
                LOG.info((Object)("Processing " + filename));
                Liquibase liquibase = new Liquibase(filename, resourceAccessor, database);
                liquibase.update(liquibaseContext);
            }
            catch (LiquibaseException e) {
                throw new RuntimeException("Failed to create Liquibase for " + filename, e);
            }
        }
    }

    private List<String> findFilenamesForPhase(int phase, List<String> packages) {
        ArrayList<String> phaseFilenames = new ArrayList<String>();
        for (String pkg : packages) {
            if (StringUtils.isEmpty((String)pkg)) {
                LOG.info((Object)"Package is empty, no files to find.");
                continue;
            }
            String sourceName = "classpath:/" + pkg + "/db/phase" + phase + "/*.xml";
            try {
                ArrayList<String> tempFilenames = new ArrayList<String>();
                Resource[] resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.applicationContext).getResources(sourceName);
                for (int i = 0; i < resources.length; ++i) {
                    tempFilenames.add(pkg + "/db/phase" + phase + "/" + resources[i].getFilename());
                }
                Collections.sort(tempFilenames);
                phaseFilenames.addAll(tempFilenames);
            }
            catch (FileNotFoundException e) {
                LOG.warn((Object)("Failed to find files for " + sourceName));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return phaseFilenames;
    }
}

