/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.s3.impl;

import co.kuali.coeus.s3.api.S3File;
import co.kuali.coeus.s3.api.S3FileMetadata;
import co.kuali.coeus.s3.api.S3FileService;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.ServerSideEncryptionByDefault;
import software.amazon.awssdk.services.s3.model.ServerSideEncryptionConfiguration;
import software.amazon.awssdk.services.s3.model.ServerSideEncryptionRule;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;
import software.amazon.awssdk.utils.IoUtils;

public class S3FileServiceimpl
implements S3FileService,
DisposableBean {
    private static final Logger LOG = LogManager.getLogger(S3FileServiceimpl.class);
    private String bucketName;
    private String replicationBucketName;
    private S3Client amazonS3;
    private boolean encryptionEnabled;
    private String encryptionKey;
    private String confidentialDataTagName;
    private boolean confidentialData;

    @Override
    public String createFile(S3File s3File) {
        String uniqueFileNameGuid;
        block6: {
            if (s3File == null) {
                throw new IllegalArgumentException("file cannot be null");
            }
            if (s3File.getByteContents() == null || s3File.getByteContents().length == 0) {
                throw new IllegalArgumentException("bytes cannot be null or empty");
            }
            if (StringUtils.isNotBlank((CharSequence)this.replicationBucketName)) {
                this.createBucketIfNeeded(this.replicationBucketName);
            }
            this.createBucketIfNeeded(this.bucketName);
            uniqueFileNameGuid = StringUtils.isNotBlank((CharSequence)s3File.getId()) ? s3File.getId() : UUID.randomUUID().toString();
            try {
                if (this.amazonS3.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucketName).key(uniqueFileNameGuid).build()).sdkHttpResponse().isSuccessful()) {
                    throw new IllegalStateException("file already exists with id " + uniqueFileNameGuid);
                }
            }
            catch (NoSuchKeyException e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
        Map<String, String> metadata = this.createObjectMetadata(s3File);
        this.amazonS3.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(uniqueFileNameGuid).metadata(metadata).build(), this.createRequestBody(s3File));
        s3File.setId(uniqueFileNameGuid);
        return uniqueFileNameGuid;
    }

    protected RequestBody createRequestBody(S3File file) {
        return RequestBody.fromBytes((byte[])file.getByteContents());
    }

    protected Map<String, String> createObjectMetadata(S3File file) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (file.getFileMetaData() != null) {
            Map<String, Object> suppliedMetadata = file.getFileMetaData().getMetadata();
            if (suppliedMetadata != null) {
                Date lastModified;
                String contentLanguage;
                String contentMd5;
                String contentEncoding;
                String cacheControl;
                Long contentLength;
                String contentType = (String)suppliedMetadata.remove("Content-Type");
                if (StringUtils.isNotBlank((CharSequence)contentType)) {
                    metadata.put("Content-Type", S3FileServiceimpl.flattenToAscii(contentType));
                }
                if ((contentLength = (Long)suppliedMetadata.remove("Content-Length")) != null) {
                    metadata.put("Content-Length", contentLength.toString());
                }
                if (StringUtils.isNotBlank((CharSequence)(cacheControl = (String)suppliedMetadata.remove("Cache-Control")))) {
                    metadata.put("Cache-Control", S3FileServiceimpl.flattenToAscii(cacheControl));
                }
                if (StringUtils.isNotBlank((CharSequence)(contentEncoding = (String)suppliedMetadata.remove("Content-Encoding")))) {
                    metadata.put("Content-Encoding", S3FileServiceimpl.flattenToAscii(contentEncoding));
                }
                if (StringUtils.isNotBlank((CharSequence)(contentMd5 = (String)suppliedMetadata.remove("Content-MD5")))) {
                    metadata.put("Content-MD5", contentMd5);
                }
                if (StringUtils.isNotBlank((CharSequence)(contentLanguage = (String)suppliedMetadata.remove("Content-Language")))) {
                    metadata.put("Content-Language", S3FileServiceimpl.flattenToAscii(contentLanguage));
                }
                if ((lastModified = (Date)suppliedMetadata.remove("Last-Modified")) != null) {
                    metadata.put("Last-Modified", lastModified.toString());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)file.getFileMetaData().getFileName())) {
                metadata.put("Content-Disposition", "attachment; filename=" + S3FileServiceimpl.flattenToAscii(file.getFileMetaData().getFileName()));
            }
            if (suppliedMetadata != null) {
                suppliedMetadata.entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).forEach(e -> metadata.put(S3FileServiceimpl.flattenToAscii((String)e.getKey()), S3FileServiceimpl.flattenToAscii(String.valueOf(e.getValue()))));
            }
        }
        metadata.put("x-amz-server-side-encryption", "AES256");
        return metadata;
    }

    private static String flattenToAscii(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        for (char c : string.toCharArray()) {
            if (c > '\u007f') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public S3File retrieveFile(String id) {
        ResponseInputStream s3Object;
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("id cannot be blank");
        }
        try {
            s3Object = this.amazonS3.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(id).build());
        }
        catch (NoSuchKeyException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
        S3File s3File = new S3File();
        try {
            s3File.setByteContents(IoUtils.toByteArray((InputStream)s3Object));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> metadata = new HashMap<String, String>(((GetObjectResponse)s3Object.response()).metadata());
        S3FileMetadata s3FileMetadata = new S3FileMetadata();
        s3FileMetadata.setMetadata(metadata);
        s3FileMetadata.setFileName((String)metadata.get("File-Name"));
        s3File.setFileMetaData(s3FileMetadata);
        s3File.setId(id);
        return s3File;
    }

    @Override
    public void updateFile(S3File s3File) {
        if (s3File == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)s3File.getId())) {
            throw new IllegalArgumentException("file id cannot be blank");
        }
        if (s3File.getByteContents() == null || s3File.getByteContents().length == 0) {
            throw new IllegalArgumentException("bytes cannot be null or empty");
        }
        try {
            if (!this.amazonS3.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucketName).key(s3File.getId()).build()).sdkHttpResponse().isSuccessful()) {
                throw new IllegalStateException("file does not exist with id " + s3File.getId());
            }
        }
        catch (NoSuchKeyException e) {
            throw new IllegalStateException("file does not exist with id " + s3File.getId(), e);
        }
        Map<String, String> metadata = this.createObjectMetadata(s3File);
        this.amazonS3.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(s3File.getId()).metadata(metadata).build(), this.createRequestBody(s3File));
    }

    @Override
    public void deleteFile(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("id cannot be blank");
        }
        this.amazonS3.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucketName).key(id).build());
    }

    private void createBucketIfNeeded(String bucket) {
        try {
            HeadBucketResponse headBucketResponse = this.amazonS3.headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(bucket).build());
            if (headBucketResponse.sdkHttpResponse().statusCode() == 404) {
                this.createBucket(bucket);
            }
        }
        catch (NoSuchBucketException e) {
            this.createBucket(bucket);
        }
    }

    private void createBucket(String bucket) {
        this.amazonS3.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(bucket).build());
        if (this.isEncryptionEnabled()) {
            ServerSideEncryptionByDefault.Builder encryptionConfigBuilder = ServerSideEncryptionByDefault.builder().sseAlgorithm(ServerSideEncryption.AWS_KMS);
            if (StringUtils.isNotBlank((CharSequence)this.getEncryptionKey())) {
                encryptionConfigBuilder.kmsMasterKeyID(this.getEncryptionKey());
            }
            this.amazonS3.putBucketEncryption((PutBucketEncryptionRequest)PutBucketEncryptionRequest.builder().bucket(bucket).serverSideEncryptionConfiguration((ServerSideEncryptionConfiguration)ServerSideEncryptionConfiguration.builder().rules(new ServerSideEncryptionRule[]{(ServerSideEncryptionRule)ServerSideEncryptionRule.builder().applyServerSideEncryptionByDefault((ServerSideEncryptionByDefault)encryptionConfigBuilder.build()).build()}).build()).build());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getConfidentialDataTagName())) {
            this.amazonS3.putBucketTagging((PutBucketTaggingRequest)PutBucketTaggingRequest.builder().bucket(bucket).tagging((Tagging)Tagging.builder().tagSet(new Tag[]{(Tag)Tag.builder().key(this.getConfidentialDataTagName()).value(Boolean.toString(this.isConfidentialData())).build()}).build()).build());
        }
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getReplicationBucketName() {
        return this.replicationBucketName;
    }

    public void setReplicationBucketName(String replicationBucketName) {
        this.replicationBucketName = replicationBucketName;
    }

    public S3Client getAmazonS3() {
        return this.amazonS3;
    }

    public void setAmazonS3(S3Client amazonS3) {
        this.amazonS3 = amazonS3;
    }

    public boolean isEncryptionEnabled() {
        return this.encryptionEnabled;
    }

    public void setEncryptionEnabled(boolean encryptionEnabled) {
        this.encryptionEnabled = encryptionEnabled;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public String getConfidentialDataTagName() {
        return this.confidentialDataTagName;
    }

    public void setConfidentialDataTagName(String confidentialDataTagName) {
        this.confidentialDataTagName = confidentialDataTagName;
    }

    public boolean isConfidentialData() {
        return this.confidentialData;
    }

    public void setConfidentialData(boolean confidentialData) {
        this.confidentialData = confidentialData;
    }

    public void destroy() {
        if (this.amazonS3 != null) {
            try {
                this.amazonS3.close();
            }
            catch (Throwable e) {
                LOG.error("Error closing S3 client", e);
            }
        }
    }
}

