/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.core;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.enhydra.jdbc.util.JdbcUtil;

public abstract class CoreConnection
extends JdbcUtil
implements Connection {
    public Connection con;

    public CoreConnection(Connection con) {
        this.con = con;
    }

    public CoreConnection() {
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.preInvoke();
        try {
            this.con.clearWarnings();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void close() throws SQLException {
        this.preInvoke();
        try {
            this.con.close();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.preInvoke();
        try {
            this.con.commit();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.preInvoke();
        try {
            return this.con.createStatement();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.preInvoke();
        try {
            return this.con.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getAutoCommit();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getCatalog();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getMetaData();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getTransactionIsolation();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    public Map getTypeMap() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getTypeMap();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getWarnings();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.preInvoke();
        try {
            return this.con.isReadOnly();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.preInvoke();
        try {
            return this.con.nativeSQL(sql);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareCall(sql);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareStatement(sql);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.preInvoke();
        try {
            this.con.rollback();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.log.debug("CoreConnection:Setautocommit autoCommit was = " + this.con.getAutoCommit());
        this.log.debug("CoreConnection:Setautocommit = " + autoCommit);
        this.preInvoke();
        try {
            this.con.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.preInvoke();
        try {
            this.con.setCatalog(catalog);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.preInvoke();
        try {
            this.con.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.preInvoke();
        try {
            this.con.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        this.preInvoke();
        try {
            this.con.setTypeMap(map);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.preInvoke();
        try {
            return this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getHoldability();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.preInvoke();
        try {
            return this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareStatement(sql, columnNames);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.preInvoke();
        try {
            this.con.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.preInvoke();
        try {
            this.con.rollback(savepoint);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.preInvoke();
        try {
            this.con.setHoldability(holdability);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.preInvoke();
        try {
            return this.con.setSavepoint();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.preInvoke();
        try {
            return this.con.setSavepoint(name);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public abstract void preInvoke() throws SQLException;

    public abstract void catchInvoke(SQLException var1) throws SQLException;

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.preInvoke();
        try {
            return this.con.unwrap(iface);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.preInvoke();
        try {
            return this.con.isWrapperFor(iface);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.preInvoke();
        try {
            return this.con.isClosed();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return true;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.preInvoke();
        try {
            return this.con.createClob();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.preInvoke();
        try {
            return this.con.createBlob();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.preInvoke();
        try {
            return this.con.createNClob();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.preInvoke();
        try {
            return this.con.createSQLXML();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.preInvoke();
        try {
            return this.con.isValid(timeout);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.preInvoke();
            try {
                this.con.setClientInfo(name, value);
            }
            catch (SQLException e) {
                this.catchInvoke(e);
            }
        }
        catch (SQLException e) {
            if (e instanceof SQLClientInfoException) {
                throw (SQLClientInfoException)e;
            }
            throw new SQLClientInfoException();
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.preInvoke();
            try {
                this.con.setClientInfo(properties);
            }
            catch (SQLException e) {
                this.catchInvoke(e);
            }
        }
        catch (SQLException e) {
            if (e instanceof SQLClientInfoException) {
                throw (SQLClientInfoException)e;
            }
            throw new SQLClientInfoException();
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.preInvoke();
        try {
            return this.con.getClientInfo(name);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getClientInfo();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.preInvoke();
        try {
            return this.con.createArrayOf(typeName, elements);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.preInvoke();
        try {
            return this.con.createStruct(typeName, attributes);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.preInvoke();
        try {
            this.con.setSchema(schema);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getSchema();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.preInvoke();
        try {
            this.con.abort(executor);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.preInvoke();
        try {
            this.con.setNetworkTimeout(executor, milliseconds);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getNetworkTimeout();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }
}

