/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.core;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.enhydra.jdbc.util.JdbcUtil;

public abstract class CoreStatement
extends JdbcUtil
implements Statement {
    protected Statement statement;

    @Override
    public void addBatch(String s) throws SQLException {
        try {
            this.statement.addBatch(s);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.statement.cancel();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.statement.clearBatch();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.statement.clearWarnings();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
        }
    }

    @Override
    public boolean execute(String s) throws SQLException {
        try {
            return this.statement.execute(s);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            return this.statement.executeBatch();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public ResultSet executeQuery(String s) throws SQLException {
        try {
            return this.statement.executeQuery(s);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public int executeUpdate(String s) throws SQLException {
        try {
            return this.statement.executeUpdate(s);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.statement.getConnection();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this.statement.getFetchDirection();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this.statement.getFetchSize();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.statement.getGeneratedKeys();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this.statement.getMaxFieldSize();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this.statement.getMaxRows();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return this.statement.getMoreResults();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this.statement.getQueryTimeout();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this.statement.getResultSet();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.statement.getResultSetConcurrency();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this.statement.getResultSetType();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return this.statement.getUpdateCount();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.statement.getWarnings();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            this.statement.setCursorName(name);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this.statement.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.statement.setFetchDirection(direction);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            this.statement.setFetchSize(rows);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            this.statement.setMaxFieldSize(max);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        try {
            this.statement.setMaxRows(max);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.statement.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.statement.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.statement.execute(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            return this.statement.execute(sql, columnNames);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.statement.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.statement.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            return this.statement.executeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        try {
            return this.statement.getMoreResults(current);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.statement.getResultSetHoldability();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    public abstract void catchInvoke(SQLException var1) throws SQLException;

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this.statement.unwrap(iface);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this.statement.isWrapperFor(iface);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.statement.isClosed();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return true;
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        try {
            this.statement.setPoolable(poolable);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            return this.statement.isPoolable();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            this.statement.closeOnCompletion();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            return this.statement.isCloseOnCompletion();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }
}

