/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.enhydra.jdbc.core.CorePreparedStatement;
import org.enhydra.jdbc.standard.StandardConnectionHandle;

public class StandardPreparedStatement
extends CorePreparedStatement
implements StatementEventListener {
    public Object key;
    private StandardConnectionHandle con;
    public boolean closed;

    StandardPreparedStatement(StandardConnectionHandle con, PreparedStatement preparedStatement, Object key) {
        this.con = con;
        this.key = key;
        this.ps = preparedStatement;
    }

    StandardPreparedStatement() {
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        if (this.con.preparedStmtCacheSize == 0) {
            if (this.ps != null) {
                this.ps.close();
            }
        } else {
            this.con.returnToCache(this.key);
        }
    }

    @Override
    public void preInvoke() throws SQLException {
        if (this.closed) {
            throw new SQLException("Prepare Statement is closed");
        }
    }

    @Override
    public void catchInvoke(SQLException sqlException) throws SQLException {
        throw sqlException;
    }

    @Override
    public void statementClosed(StatementEvent event) {
    }

    @Override
    public void statementErrorOccurred(StatementEvent event) {
    }
}

