/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.XAConnection;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.enhydra.jdbc.standard.StandardPooledConnection;
import org.enhydra.jdbc.standard.StandardXAConnectionHandle;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.enhydra.jdbc.standard.StandardXAStatefulConnection;

public class StandardXAConnection
extends StandardPooledConnection
implements XAConnection,
XAResource,
Referenceable,
Runnable {
    protected StandardXAStatefulConnection curCon;
    private boolean commitOnPrepare;
    boolean isClosed;
    private int timeoutSecs;
    private long timeoutPeriod = 60000L;
    private long nextTimeout;
    public Thread timerThread;
    public TransactionManager transactionManager;
    public StandardXAConnectionHandle connectionHandle;
    protected StandardXADataSource xaDataSource;
    public boolean thisAutoCommit = true;

    public StandardXAConnection(StandardXADataSource dataSource, String user, String password) throws SQLException {
        super(dataSource, user, password);
        this.xaDataSource = dataSource;
        this.curCon = new StandardXAStatefulConnection(dataSource, this.con);
        dataSource.log.debug("StandardXAConnection created");
    }

    @Override
    public XAResource getXAResource() {
        return this;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        this.dataSource.log.debug("StandardXAConnection:getConnection");
        if (this.connectionHandle != null && !this.connectionHandle.isClosed()) {
            this.connectionHandle.close();
        }
        if (this.curCon == null) {
            this.curCon = this.xaDataSource.getFreeConnection();
            this.con = this.curCon.con;
        }
        this.newConnectionHandle();
        this.dataSource.log.debug("StandardXAConnection:getConnection return a connection");
        return this.connectionHandle;
    }

    @Override
    protected void newConnectionHandle() {
        this.connectionHandle = new StandardXAConnectionHandle(this, this.dataSource.getMasterPrepStmtCache(), this.dataSource.getPreparedStmtCacheSize(), this.transactionManager);
    }

    public void setTransactionManager(TransactionManager tm) {
        this.transactionManager = tm;
    }

    @Override
    public synchronized void close() throws SQLException {
        this.dataSource.log.debug("StandardXAConnection:close the XAConnection");
        if (this.curCon != null && !this.curCon.con.isClosed()) {
            this.curCon.con.close();
            this.dataSource.getMasterPrepStmtCache().remove(this.curCon.toString());
        } else if (this.xaDataSource.freeConnections.size() > 1) {
            this.curCon = this.xaDataSource.getFreeConnection();
            this.curCon.con.close();
            this.dataSource.getMasterPrepStmtCache().remove(this.curCon.con.toString());
        }
        this.curCon = null;
        this.con = null;
        this.xaDataSource.connectionClosed();
        this.isClosed = true;
        this.connectionHandle = null;
        this.nextTimeout = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doStart(Xid xid, int flags) throws XAException {
        block25: {
            this.dataSource.log.debug("StandardXAConnection:doStart xid='" + xid + "' flags='" + flags + "'");
            if (xid == null) {
                throw new XAException(-5);
            }
            if (flags == 0x8000000 || flags == 0x200000) {
                try {
                    this.xaDataSource.processToWait();
                }
                catch (Exception e) {
                    throw new XAException("Exception : " + e.toString());
                }
                StandardXADataSource e = this.xaDataSource;
                synchronized (e) {
                    if (this.curCon != null && !this.xaDataSource.freeConnections.contains(this.curCon)) {
                        this.xaDataSource.freeConnections.addElement(this.curCon);
                    }
                }
                this.curCon = this.xaDataSource.getConnection(xid, true);
                this.con = this.curCon.con;
            }
            if (this.curCon == null) {
                try {
                    this.curCon = this.xaDataSource.getFreeConnection();
                    this.con = this.curCon.con;
                }
                catch (Exception e) {
                    this.dataSource.log.error("error while gettting connection " + e, e);
                }
                this.dataSource.log.debug("StandardXAConnection:doStart curCon is null");
            }
            StandardXAConnectionHandle xad = this.connectionHandle;
            try {
                xad.setGlobalTransaction(true);
                if (flags != 0x8000000 || !xad.resetTxonResume) break block25;
                xad.resetTxonResume = false;
                if (this.transactionManager == null || xad.tx != null) break block25;
                try {
                    this.connectionHandle.tx = this.transactionManager.getTransaction();
                }
                catch (SystemException se) {
                    throw new XAException(se.toString());
                }
            }
            catch (SQLException e) {
                throw new XAException(e.toString());
            }
        }
        if (this.timeoutSecs != 0) {
            this.curCon.timeout = System.currentTimeMillis() + (long)(this.timeoutSecs * 1000);
            if (this.nextTimeout == 0L) {
                this.nextTimeout = this.curCon.timeout;
                this.notify();
            } else if (this.curCon.timeout < this.nextTimeout) {
                this.nextTimeout = this.curCon.timeout;
            }
        }
        this.curCon.xid = xid;
        this.curCon.timedOut = false;
        this.curCon.commitOnPrepare = this.commitOnPrepare;
        if (!this.xaDataSource.xidConnections.containsKey(xid)) {
            try {
                this.log.debug("StandardXAConnection:dostart before processToWait");
                this.xaDataSource.processToWait();
                this.log.debug("StandardXAConnection:dostart after processToWait");
            }
            catch (Exception e) {
                throw new XAException("Exception : " + e.toString());
            }
            StandardXADataSource standardXADataSource = this.xaDataSource;
            synchronized (standardXADataSource) {
                this.xaDataSource.xidConnections.put(xid, this.curCon);
            }
        }
        this.curCon.setState(0);
    }

    @Override
    public synchronized void start(Xid xid, int flags) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:start associate the current connection with a global transaction");
        this.doStart(xid, flags);
        this.curCon = null;
    }

    @Override
    public synchronized void end(Xid xid, int flags) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:end");
        this.dataSource.log.debug("StandardXAConnection:end xid='" + xid + "' flags='" + flags + "'");
        if (xid == null) {
            throw new XAException(-5);
        }
        StandardXAStatefulConnection statecon = this.xaDataSource.getConnection(xid, true);
        int state = statecon.getState();
        if (state != 0) {
            throw new XAException(-6);
        }
        if (this.connectionHandle.tx != null) {
            this.connectionHandle.resetTxonResume = true;
        }
        this.connectionHandle.tx = null;
        this.connectionHandle.globalTransaction = false;
    }

    public StandardXAStatefulConnection checkPreparedState(Xid xid) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:checkPreparedState");
        if (xid == null) {
            throw new XAException(-5);
        }
        StandardXAStatefulConnection statecon = this.xaDataSource.getConnection(xid, true);
        try {
            if (statecon.commitOnPrepare) {
                statecon.con.commit();
                statecon.setState(7);
            } else {
                statecon.setState(2);
            }
        }
        catch (SQLException e) {
            this.dataSource.log.error("StandardXAConnection:checkPrepareState Exception on prepare, rolling back");
            statecon.setState(6);
            throw new XAException(100);
        }
        return statecon;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:prepare prepare to perform a commit");
        this.checkPreparedState(xid);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:commit perform a commit");
        if (xid == null) {
            throw new XAException(-5);
        }
        StandardXAStatefulConnection statecon = this.xaDataSource.getConnection(xid, true);
        this.dataSource.log.debug("StandardXAConnection:commit case(state)");
        try {
            switch (statecon.getState()) {
                case 7: {
                    return;
                }
                case 2: {
                    try {
                        this.dataSource.log.debug("StandardXAConnection:commit try to commit a connection (STATUS_PREPARED)");
                        statecon.con.commit();
                        this.dataSource.log.debug("StandardXAConnection:commit commit is ok");
                        return;
                    }
                    catch (SQLException e) {
                        throw new XAException(100);
                    }
                }
                case 0: 
                case 3: {
                    if (!onePhase) {
                        throw new XAException(-6);
                    }
                    try {
                        this.dataSource.log.debug("StandardXAConnection:commit try to commit a connection (STATUS_ACTIVE)");
                        statecon.con.commit();
                        this.dataSource.log.debug("StandardXAConnection:commit commit is ok");
                        return;
                    }
                    catch (SQLException e) {
                        throw new XAException(100);
                    }
                }
                default: {
                    this.dataSource.log.debug("StandardXAConnection:commit UNKNOWN STATUS!:" + statecon.getState());
                    throw new XAException(-6);
                }
            }
        }
        catch (XAException e) {
            throw e;
        }
        finally {
            try {
                this.dataSource.log.debug("StandardXAConnection:commit setAutoCommit to '" + this.thisAutoCommit + "'");
                statecon.con.setAutoCommit(this.thisAutoCommit);
            }
            catch (SQLException e) {
                this.dataSource.log.debug("StandardXAConnection:commit setAutoCommit problem");
            }
            this.xaDataSource.freeConnection(xid, false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void rollback(Xid xid) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:rollback");
        if (xid == null) {
            throw new XAException(-5);
        }
        StandardXAStatefulConnection statecon = this.xaDataSource.getConnection(xid, true);
        try {
            switch (statecon.getState()) {
                case 7: {
                    throw new XAException(7);
                }
                case 0: 
                case 2: 
                case 9: {
                    try {
                        this.dataSource.log.debug("StandardXAConnection:rollback try to perform the rollback operation");
                        statecon.con.rollback();
                        this.dataSource.log.debug("StandardXAConnection:rollback performed the rollback");
                        return;
                    }
                    catch (SQLException e) {
                        throw new XAException(100);
                    }
                }
                default: {
                    throw new XAException(-6);
                }
            }
        }
        catch (XAException e) {
            throw e;
        }
        finally {
            try {
                this.dataSource.log.debug("StandardXAConnection:rollback setAutoCommit to '" + this.thisAutoCommit + "'");
                statecon.con.setAutoCommit(this.thisAutoCommit);
            }
            catch (SQLException e) {
                this.dataSource.log.debug("StandardXAConnection:rollback setAutoCommit problem");
            }
            this.xaDataSource.freeConnection(xid, false);
        }
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:isSameRM");
        if (this.equals(xares)) {
            this.dataSource.log.debug("StandardXAConnection:isSameRM isSameRM");
            return true;
        }
        if (!(xares instanceof StandardXAConnection)) {
            this.dataSource.log.debug("StandardXAConnection:isSameRM not isSameRM");
            return false;
        }
        StandardXAConnection xac = (StandardXAConnection)xares;
        if (this.dataSource.equals(xac.dataSource)) {
            this.dataSource.log.debug("StandardXAConnection:isSameRM isSameRM (equal datasource)");
            return true;
        }
        this.dataSource.log.debug("StandardXAConnection:isSameRM not isSameRM (not equal datasource)");
        return false;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:forget forget with Xid");
        if (xid == null) {
            throw new XAException(-5);
        }
        this.xaDataSource.freeConnection(xid, false);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:recover recover flag=" + flag);
        if (flag != 0x1000000 && flag != 0x800000 && flag != 0) {
            throw new XAException(-5);
        }
        Xid[] retval = null;
        retval = this.xaDataSource.recover();
        return retval;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) {
        this.timeoutSecs = seconds;
        return false;
    }

    @Override
    public int getTransactionTimeout() {
        return this.timeoutSecs;
    }

    public void setCommitOnPrepare(boolean commitOnPrepare) {
        this.commitOnPrepare = commitOnPrepare;
    }

    public boolean getCommitOnPrepare() {
        return this.commitOnPrepare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                StandardXAConnection standardXAConnection = this;
                synchronized (standardXAConnection) {
                    while (this.nextTimeout == 0L) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.isClosed) {
                return;
            }
            try {
                Thread.sleep(this.timeoutPeriod);
                if (this.isClosed) {
                    return;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            long curTime = System.currentTimeMillis();
            if (curTime < this.nextTimeout) continue;
            try {
                this.nextTimeout = this.xaDataSource.checkTimeouts(curTime);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        this.dataSource.log.debug("StandardXAConnection:getReference return a reference of the object");
        Reference ref = new Reference(this.getClass().getName(), this.getClass().getName(), null);
        ref.add(new StringRefAddr("commitOnPrepare", String.valueOf(this.getCommitOnPrepare())));
        ref.add(new StringRefAddr("timeoutSecs", Integer.toString(this.getTransactionTimeout())));
        return ref;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StandardXAConnection:\n");
        sb.append("     commit on prepare =<" + this.commitOnPrepare + ">\n");
        sb.append("     is closed =<" + this.isClosed + ">\n");
        sb.append("     this autoCommit =<" + this.thisAutoCommit + ">\n");
        sb.append("     listeners size =<" + this.listeners.size() + ">\n");
        sb.append("     next timeOut =<" + this.nextTimeout + ">\n");
        sb.append("     timeOut period =<" + this.timeoutPeriod + ">\n");
        sb.append("     timeOut secs =<" + this.timeoutSecs + ">\n");
        sb.append("     transaction manager=<" + this.transactionManager + ">\n");
        sb.append(this.xaDataSource.toString());
        sb.append(this.dataSource.toString());
        if (this.curCon != null) {
            sb.append(this.curCon.toString());
        }
        if (this.connectionHandle != null) {
            sb.append(this.connectionHandle.toString());
        }
        if (this.con != null) {
            sb.append(this.con.toString());
        }
        return sb.toString();
    }
}

