/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.LogFactory;
import org.enhydra.jdbc.standard.StandardConnectionPoolDataSource;
import org.enhydra.jdbc.standard.StandardXAConnection;
import org.enhydra.jdbc.standard.StandardXAStatefulConnection;
import org.enhydra.jdbc.util.Logger;

public class StandardXADataSource
extends StandardConnectionPoolDataSource
implements XADataSource {
    public int minCon = 50;
    public int maxCon = 0;
    public long deadLockMaxWait = 300000L;
    Vector freeConnections = new Vector(this.minCon, 1);
    Hashtable xidConnections = new Hashtable(this.minCon * 2, 0.5f);
    Hashtable deadConnections;
    public int connectionCount = 0;
    public long deadLockRetryWait = 10000L;
    public transient TransactionManager transactionManager;
    public static final int DEFAULT_MIN_CON = 50;
    public static final int DEFAULT_MAX_CON = 0;
    public static final long DEFAULT_DEADLOCKMAXWAIT = 300000L;
    public static final int DEFAULT_DEADLOCKRETRYWAIT = 10000;

    public StandardXADataSource() {
        this.log = new Logger(LogFactory.getLog((String)"org.enhydra.jdbc.xapool"));
        this.log.debug("StandardXADataSource is created");
    }

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public Hashtable getXidConnections() {
        return this.xidConnections;
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        this.log.debug("StandardXADataSource:getXAConnection(0) XA connection returned");
        return this.getXAConnection(this.user, this.password);
    }

    @Override
    public synchronized XAConnection getXAConnection(String user, String password) throws SQLException {
        this.log.debug("StandardXADataSource:getXAConnection(user, password)");
        StandardXAConnection xac = new StandardXAConnection(this, user, password);
        xac.setTransactionManager(this.transactionManager);
        xac.setLogger(this.log);
        ++this.connectionCount;
        return xac;
    }

    public void setTransactionManager(TransactionManager tm) {
        this.log.debug("StandardXADataSource:setTransactionManager");
        this.transactionManager = tm;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public void setUser(String user) {
        this.log.debug("StandardXADataSource:setUser");
        if (user == null || this.getUser() == null ? user != this.getUser() : !user.equals(this.getUser())) {
            super.setUser(user);
            this.resetCache();
        }
    }

    @Override
    public void setPassword(String password) {
        this.log.debug("StandardXADataSource:setPassword");
        if (password == null || this.getPassword() == null ? password != this.getPassword() : !password.equals(this.getPassword())) {
            super.setPassword(password);
            this.resetCache();
        }
    }

    @Override
    public void setUrl(String url) {
        if (url == null || this.getUrl() == null ? url != this.getUrl() : !url.equals(this.getUrl())) {
            super.setUrl(url);
            this.resetCache();
        }
    }

    @Override
    public void setDriverName(String driverName) throws SQLException {
        if (driverName == null && this.getDriverName() != null || !driverName.equals(this.getDriverName())) {
            super.setDriverName(driverName);
            this.resetCache();
        }
    }

    private synchronized void resetCache() {
        this.log.debug("StandardXADataSource:resetCache");
        this.deadConnections = (Hashtable)this.xidConnections.clone();
        this.deadConnections.putAll(this.xidConnections);
        Enumeration e = this.freeConnections.elements();
        while (e.hasMoreElements()) {
            StandardXAStatefulConnection xasc = (StandardXAStatefulConnection)e.nextElement();
            try {
                this.log.debug("StandardXADataSource:resetCache closing Connection:" + xasc.con);
                xasc.con.close();
            }
            catch (SQLException ex) {
                this.log.error("StandardXADataSource:resetCache Error closing connection:" + xasc.con);
            }
            this.freeConnections.removeElement(xasc);
        }
    }

    synchronized void connectionClosed() throws SQLException {
        this.log.debug("StandardXADataSource:connectionClosed");
        --this.connectionCount;
        if (this.connectionCount == 0) {
            StandardXAStatefulConnection cur;
            Enumeration cons = this.xidConnections.keys();
            while (cons.hasMoreElements()) {
                Object key = cons.nextElement();
                cur = (StandardXAStatefulConnection)this.xidConnections.remove(key);
                if (cur != null) {
                    cur.con.close();
                }
                this.log.debug("StandardXADataSource:connectionClosed close physical connection");
            }
            Iterator connIterator = this.freeConnections.iterator();
            while (connIterator.hasNext()) {
                cur = (StandardXAStatefulConnection)connIterator.next();
                cur.con.close();
                connIterator.remove();
                this.log.debug("StandardXADataSource:connectionClosed close any free connections");
            }
        }
    }

    public int getXidCount() {
        int count = 0;
        Enumeration cons = this.xidConnections.elements();
        while (cons.hasMoreElements()) {
            Object o = cons.nextElement();
            StandardXAStatefulConnection cur = (StandardXAStatefulConnection)o;
            if (cur.getState() != 2 && cur.getState() != 7) continue;
            ++count;
        }
        this.log.debug("StandardXADataSource:getXidCount return XidCount=<" + count + ">");
        return count;
    }

    Xid[] recover() {
        int nodeCount = this.getXidCount();
        Xid[] xids = new Xid[nodeCount];
        int i = 0;
        Enumeration cons = this.xidConnections.elements();
        while (cons.hasMoreElements()) {
            Object o = cons.nextElement();
            StandardXAStatefulConnection cur = (StandardXAStatefulConnection)o;
            if (cur.getState() != 2 && cur.getState() != 7) continue;
            xids[i++] = cur.xid;
        }
        return xids;
    }

    public synchronized void freeConnection(Xid id, boolean placeAtStart) {
        this.log.debug("StandardXADataSource:freeConnection");
        Object o = this.xidConnections.get(id);
        StandardXAStatefulConnection cur = (StandardXAStatefulConnection)o;
        this.xidConnections.remove(id);
        this.log.debug("StandardXADataSource:freeConnection remove id from xidConnections");
        if (!this.deadConnections.containsKey(id)) {
            cur.setState(6);
            if (!this.freeConnections.contains(cur)) {
                if (placeAtStart) {
                    this.freeConnections.insertElementAt(cur, 0);
                } else {
                    this.freeConnections.addElement(cur);
                }
            }
        } else {
            this.deadConnections.remove(id);
            try {
                cur.con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.notify();
    }

    synchronized long checkTimeouts(long curTime) throws SQLException {
        long nextTimeout = 0L;
        Enumeration cons = this.xidConnections.elements();
        while (cons.hasMoreElements()) {
            Object o = cons.nextElement();
            StandardXAStatefulConnection cur = (StandardXAStatefulConnection)o;
            if (cur.timeout != 0L && curTime > cur.timeout) {
                cur.con.rollback();
                cur.timedOut = true;
                this.freeConnection(cur.xid, true);
                continue;
            }
            if (cur.timeout == 0L || cur.timeout >= nextTimeout && nextTimeout != 0L) continue;
            nextTimeout = cur.timeout;
        }
        return nextTimeout;
    }

    private synchronized void checkTimeouts(Xid xid) throws XAException {
        this.log.debug("StandardXADataSource:checkTimeouts");
        for (int i = 0; i < this.freeConnections.size(); ++i) {
            Object o = this.freeConnections.elementAt(i);
            StandardXAStatefulConnection cur = (StandardXAStatefulConnection)o;
            if (!cur.timedOut) continue;
            this.log.debug("StandardXADataSource:checkTimeouts (" + i + "/" + this.freeConnections.size() + ") xid     = " + xid);
            this.log.debug("StandardXADataSource:checkTimeouts cur.xid = " + cur.xid);
            if (!xid.equals(cur.xid)) continue;
            cur.timedOut = false;
            throw new XAException(106);
        }
    }

    synchronized StandardXAStatefulConnection getConnection(Xid xid, boolean mustFind) throws XAException {
        this.log.debug("StandardXADataSource:getConnection (xid=" + xid + ", mustFind=" + mustFind + ")");
        Object o = this.xidConnections.get(xid);
        this.log.debug("XID: " + o);
        StandardXAStatefulConnection cur = (StandardXAStatefulConnection)o;
        if (mustFind) {
            if (cur == null) {
                this.log.debug("StandardXADataSource:getConnection (StatefulConnection is null)");
                this.checkTimeouts(xid);
                throw new XAException(-4);
            }
        } else if (cur != null) {
            throw new XAException(-8);
        }
        this.log.debug("StandardXADataSource:getConnection return connection associated with a given XID");
        return cur;
    }

    public synchronized StandardXAStatefulConnection getFreeConnection() throws SQLException {
        this.log.debug("StandardXADataSource:getFreeConnection");
        StandardXAStatefulConnection cur = null;
        int freeCount = this.freeConnections.size();
        if (freeCount == 0) {
            this.log.debug("StandardXADataSource:getFreeConnection  there are no free connections, get a new database connection");
            Connection con = super.getConnection(this.user, this.password);
            cur = new StandardXAStatefulConnection(this, con);
        } else {
            Object o = this.freeConnections.lastElement();
            cur = (StandardXAStatefulConnection)o;
            this.freeConnections.removeElementAt(freeCount - 1);
            cur.timeout = 0L;
            cur.timedOut = false;
        }
        this.log.debug("StandardXADataSource:getFreeConnection return a connection from the free list");
        try {
            this.log.debug("StandardXADataSource:getFreeConnection setAutoCommit(true)");
            cur.con.setAutoCommit(true);
        }
        catch (SQLException e) {
            this.log.error("StandardXADataSource:getFreeConnection ERROR: Failed while autocommiting a connection: " + e);
        }
        return cur;
    }

    public void closeFreeConnection() {
        this.log.debug("StandardXADataSource:closeFreeConnection empty method TBD");
    }

    public void setMinCon(int min) {
        this.minCon = min;
    }

    public void setMaxCon(int max) {
        this.maxCon = max;
    }

    public void setDeadLockMaxWait(long deadLock) {
        this.deadLockMaxWait = deadLock;
    }

    public int getMinCon() {
        return this.minCon;
    }

    public int getMaxCon() {
        return this.maxCon;
    }

    public long getDeadLockMaxWait() {
        return this.deadLockMaxWait;
    }

    public int getAllConnections() {
        return this.xidConnections.size() + this.freeConnections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processToWait() throws Exception {
        this.log.debug("StandardXADataSource:processToWait");
        int currentWait = 0;
        if (this.maxCon != 0) {
            while (this.getAllConnections() >= this.maxCon && (long)currentWait < this.getDeadLockMaxWait()) {
                this.dump();
                try {
                    StandardXADataSource standardXADataSource = this;
                    synchronized (standardXADataSource) {
                        this.wait(this.getDeadLockRetryWait());
                    }
                }
                catch (InterruptedException e) {
                    this.log.error("StandardXADataSource:processToWait ERROR: Failed while waiting for an object: " + e);
                }
                currentWait = (int)((long)currentWait + this.getDeadLockRetryWait());
            }
            if (this.getAllConnections() >= this.getMaxCon()) {
                throw new Exception("StandardXADataSource:processToWait ERROR : impossible to obtain a new xa connection");
            }
        }
    }

    public void dump() {
        for (int i = 0; i < this.freeConnections.size(); ++i) {
            this.log.debug("freeConnection:<" + this.freeConnections.elementAt(i).toString() + ">");
        }
        Enumeration e = this.xidConnections.elements();
        while (e.hasMoreElements()) {
            this.log.debug("xidConnection:<" + e.nextElement().toString() + ">");
        }
    }

    public void setDeadLockRetryWait(long deadLockRetryWait) {
        this.deadLockRetryWait = deadLockRetryWait;
    }

    public long getDeadLockRetryWait() {
        return this.deadLockRetryWait;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StandardXADataSource:\n");
        sb.append("     connection count=<" + this.connectionCount + ">\n");
        if (this.deadConnections != null) {
            sb.append("     number of dead connection=<" + this.deadConnections.size() + ">\n");
        }
        sb.append("     dead lock max wait=<" + this.deadLockMaxWait + ">\n");
        sb.append("     dead lock retry wait=<" + this.deadLockRetryWait + ">\n");
        if (this.driver != null) {
            sb.append("     driver=<" + this.driver.toString() + ">\n");
        }
        sb.append("     driver name=<" + this.driverName + ">\n");
        if (this.freeConnections != null) {
            sb.append("     number of *free* connections=<" + this.freeConnections.size() + ">\n");
        }
        sb.append("     max con=<" + this.maxCon + ">\n");
        sb.append("     min con=<" + this.minCon + ">\n");
        sb.append("     prepared stmt cache size=<" + this.preparedStmtCacheSize + ">\n");
        sb.append("     transaction manager=<" + this.transactionManager + ">\n");
        sb.append("     xid connection size=<" + this.xidConnections.size() + ">\n");
        sb.append(super.toString());
        return sb.toString();
    }
}

