/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.DescribeSnapshotsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotsRequest>, DescribeSnapshotsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeSnapshotsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeSnapshotsRequest> marshall(DescribeSnapshotsRequest describeSnapshotsRequest) {
        if (describeSnapshotsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSnapshotsRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.DescribeSnapshots");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList snapshotIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeSnapshotsRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(describeSnapshotsRequest.getDirectoryId());
            }
            if (!(snapshotIdsList = (SdkInternalList)describeSnapshotsRequest.getSnapshotIds()).isEmpty() || !snapshotIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SnapshotIds");
                jsonGenerator.writeStartArray();
                for (String snapshotIdsListValue : snapshotIdsList) {
                    if (snapshotIdsListValue == null) continue;
                    jsonGenerator.writeValue(snapshotIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeSnapshotsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeSnapshotsRequest.getNextToken());
            }
            if (describeSnapshotsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeSnapshotsRequest.getLimit().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

