/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.AutoScalingGroup;
import com.amazonaws.services.elasticbeanstalk.model.Instance;
import com.amazonaws.services.elasticbeanstalk.model.LaunchConfiguration;
import com.amazonaws.services.elasticbeanstalk.model.LoadBalancer;
import com.amazonaws.services.elasticbeanstalk.model.Queue;
import com.amazonaws.services.elasticbeanstalk.model.Trigger;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class EnvironmentResourceDescription
implements Serializable,
Cloneable {
    private String environmentName;
    private SdkInternalList<AutoScalingGroup> autoScalingGroups;
    private SdkInternalList<Instance> instances;
    private SdkInternalList<LaunchConfiguration> launchConfigurations;
    private SdkInternalList<LoadBalancer> loadBalancers;
    private SdkInternalList<Trigger> triggers;
    private SdkInternalList<Queue> queues;

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public EnvironmentResourceDescription withEnvironmentName(String environmentName) {
        this.setEnvironmentName(environmentName);
        return this;
    }

    public List<AutoScalingGroup> getAutoScalingGroups() {
        if (this.autoScalingGroups == null) {
            this.autoScalingGroups = new SdkInternalList();
        }
        return this.autoScalingGroups;
    }

    public void setAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
            return;
        }
        this.autoScalingGroups = new SdkInternalList(autoScalingGroups);
    }

    public EnvironmentResourceDescription withAutoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
        if (this.autoScalingGroups == null) {
            this.setAutoScalingGroups((Collection<AutoScalingGroup>)new SdkInternalList(autoScalingGroups.length));
        }
        for (AutoScalingGroup ele : autoScalingGroups) {
            this.autoScalingGroups.add((Object)ele);
        }
        return this;
    }

    public EnvironmentResourceDescription withAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
        this.setAutoScalingGroups(autoScalingGroups);
        return this;
    }

    public List<Instance> getInstances() {
        if (this.instances == null) {
            this.instances = new SdkInternalList();
        }
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new SdkInternalList(instances);
    }

    public EnvironmentResourceDescription withInstances(Instance ... instances) {
        if (this.instances == null) {
            this.setInstances((Collection<Instance>)new SdkInternalList(instances.length));
        }
        for (Instance ele : instances) {
            this.instances.add((Object)ele);
        }
        return this;
    }

    public EnvironmentResourceDescription withInstances(Collection<Instance> instances) {
        this.setInstances(instances);
        return this;
    }

    public List<LaunchConfiguration> getLaunchConfigurations() {
        if (this.launchConfigurations == null) {
            this.launchConfigurations = new SdkInternalList();
        }
        return this.launchConfigurations;
    }

    public void setLaunchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
        if (launchConfigurations == null) {
            this.launchConfigurations = null;
            return;
        }
        this.launchConfigurations = new SdkInternalList(launchConfigurations);
    }

    public EnvironmentResourceDescription withLaunchConfigurations(LaunchConfiguration ... launchConfigurations) {
        if (this.launchConfigurations == null) {
            this.setLaunchConfigurations((Collection<LaunchConfiguration>)new SdkInternalList(launchConfigurations.length));
        }
        for (LaunchConfiguration ele : launchConfigurations) {
            this.launchConfigurations.add((Object)ele);
        }
        return this;
    }

    public EnvironmentResourceDescription withLaunchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
        this.setLaunchConfigurations(launchConfigurations);
        return this;
    }

    public List<LoadBalancer> getLoadBalancers() {
        if (this.loadBalancers == null) {
            this.loadBalancers = new SdkInternalList();
        }
        return this.loadBalancers;
    }

    public void setLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        if (loadBalancers == null) {
            this.loadBalancers = null;
            return;
        }
        this.loadBalancers = new SdkInternalList(loadBalancers);
    }

    public EnvironmentResourceDescription withLoadBalancers(LoadBalancer ... loadBalancers) {
        if (this.loadBalancers == null) {
            this.setLoadBalancers((Collection<LoadBalancer>)new SdkInternalList(loadBalancers.length));
        }
        for (LoadBalancer ele : loadBalancers) {
            this.loadBalancers.add((Object)ele);
        }
        return this;
    }

    public EnvironmentResourceDescription withLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        this.setLoadBalancers(loadBalancers);
        return this;
    }

    public List<Trigger> getTriggers() {
        if (this.triggers == null) {
            this.triggers = new SdkInternalList();
        }
        return this.triggers;
    }

    public void setTriggers(Collection<Trigger> triggers) {
        if (triggers == null) {
            this.triggers = null;
            return;
        }
        this.triggers = new SdkInternalList(triggers);
    }

    public EnvironmentResourceDescription withTriggers(Trigger ... triggers) {
        if (this.triggers == null) {
            this.setTriggers((Collection<Trigger>)new SdkInternalList(triggers.length));
        }
        for (Trigger ele : triggers) {
            this.triggers.add((Object)ele);
        }
        return this;
    }

    public EnvironmentResourceDescription withTriggers(Collection<Trigger> triggers) {
        this.setTriggers(triggers);
        return this;
    }

    public List<Queue> getQueues() {
        if (this.queues == null) {
            this.queues = new SdkInternalList();
        }
        return this.queues;
    }

    public void setQueues(Collection<Queue> queues) {
        if (queues == null) {
            this.queues = null;
            return;
        }
        this.queues = new SdkInternalList(queues);
    }

    public EnvironmentResourceDescription withQueues(Queue ... queues) {
        if (this.queues == null) {
            this.setQueues((Collection<Queue>)new SdkInternalList(queues.length));
        }
        for (Queue ele : queues) {
            this.queues.add((Object)ele);
        }
        return this;
    }

    public EnvironmentResourceDescription withQueues(Collection<Queue> queues) {
        this.setQueues(queues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnvironmentName() != null) {
            sb.append("EnvironmentName: ").append(this.getEnvironmentName()).append(",");
        }
        if (this.getAutoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(this.getAutoScalingGroups()).append(",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: ").append(this.getInstances()).append(",");
        }
        if (this.getLaunchConfigurations() != null) {
            sb.append("LaunchConfigurations: ").append(this.getLaunchConfigurations()).append(",");
        }
        if (this.getLoadBalancers() != null) {
            sb.append("LoadBalancers: ").append(this.getLoadBalancers()).append(",");
        }
        if (this.getTriggers() != null) {
            sb.append("Triggers: ").append(this.getTriggers()).append(",");
        }
        if (this.getQueues() != null) {
            sb.append("Queues: ").append(this.getQueues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentResourceDescription)) {
            return false;
        }
        EnvironmentResourceDescription other = (EnvironmentResourceDescription)obj;
        if (other.getEnvironmentName() == null ^ this.getEnvironmentName() == null) {
            return false;
        }
        if (other.getEnvironmentName() != null && !other.getEnvironmentName().equals(this.getEnvironmentName())) {
            return false;
        }
        if (other.getAutoScalingGroups() == null ^ this.getAutoScalingGroups() == null) {
            return false;
        }
        if (other.getAutoScalingGroups() != null && !other.getAutoScalingGroups().equals(this.getAutoScalingGroups())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getLaunchConfigurations() == null ^ this.getLaunchConfigurations() == null) {
            return false;
        }
        if (other.getLaunchConfigurations() != null && !other.getLaunchConfigurations().equals(this.getLaunchConfigurations())) {
            return false;
        }
        if (other.getLoadBalancers() == null ^ this.getLoadBalancers() == null) {
            return false;
        }
        if (other.getLoadBalancers() != null && !other.getLoadBalancers().equals(this.getLoadBalancers())) {
            return false;
        }
        if (other.getTriggers() == null ^ this.getTriggers() == null) {
            return false;
        }
        if (other.getTriggers() != null && !other.getTriggers().equals(this.getTriggers())) {
            return false;
        }
        if (other.getQueues() == null ^ this.getQueues() == null) {
            return false;
        }
        return other.getQueues() == null || other.getQueues().equals(this.getQueues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnvironmentName() == null ? 0 : this.getEnvironmentName().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroups() == null ? 0 : this.getAutoScalingGroups().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchConfigurations() == null ? 0 : this.getLaunchConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancers() == null ? 0 : this.getLoadBalancers().hashCode());
        hashCode = 31 * hashCode + (this.getTriggers() == null ? 0 : this.getTriggers().hashCode());
        hashCode = 31 * hashCode + (this.getQueues() == null ? 0 : this.getQueues().hashCode());
        return hashCode;
    }

    public EnvironmentResourceDescription clone() {
        try {
            return (EnvironmentResourceDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

