/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.model.GetCommandInvocationRequest;
import com.amazonaws.services.simplesystemsmanagement.waiters.CommandExecuted;
import com.amazonaws.services.simplesystemsmanagement.waiters.GetCommandInvocationFunction;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AWSSimpleSystemsManagementWaiters {
    private final AWSSimpleSystemsManagement client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AWSSimpleSystemsManagementWaiters");

    @SdkInternalApi
    public AWSSimpleSystemsManagementWaiters(AWSSimpleSystemsManagement client) {
        this.client = client;
    }

    public Waiter<GetCommandInvocationRequest> commandExecuted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetCommandInvocationFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new CommandExecuted.IsPendingMatcher(), new CommandExecuted.IsInProgressMatcher(), new CommandExecuted.IsDelayedMatcher(), new CommandExecuted.IsSuccessMatcher(), new CommandExecuted.IsCancelledMatcher(), new CommandExecuted.IsTimedOutMatcher(), new CommandExecuted.IsFailedMatcher(), new CommandExecuted.IsCancellingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

