/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentBootstrap {
    public static void premain(String agentArgs, Instrumentation inst) {
        AgentBootstrap.agentmain(agentArgs, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        try {
            URL bootstrapURL = AgentBootstrap.installBootstrapJar(inst);
            Class<?> agentClass = ClassLoader.getSystemClassLoader().loadClass("datadog.trace.bootstrap.Agent");
            Method startMethod = agentClass.getMethod("start", Instrumentation.class, URL.class);
            startMethod.invoke(null, inst, bootstrapURL);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static synchronized URL installBootstrapJar(Instrumentation inst) throws IOException, URISyntaxException {
        File bootstrapFile;
        URL bootstrapURL = null;
        CodeSource codeSource = AgentBootstrap.class.getProtectionDomain().getCodeSource();
        if (codeSource != null && !(bootstrapFile = new File((bootstrapURL = codeSource.getLocation()).toURI())).isDirectory()) {
            inst.appendToBootstrapClassLoaderSearch(new JarFile(bootstrapFile));
            return bootstrapURL;
        }
        System.out.println("Could not get bootstrap jar from code source, using -javaagent arg");
        List<String> arguments = AgentBootstrap.getVMArgumentsThroughReflection();
        String agentArgument = null;
        for (String arg : arguments) {
            if (!arg.startsWith("-javaagent")) continue;
            if (agentArgument == null) {
                agentArgument = arg;
                continue;
            }
            throw new RuntimeException("Multiple javaagents specified and code source unavailable, not installing tracing agent");
        }
        if (agentArgument == null) {
            throw new RuntimeException("Could not find javaagent parameter and code source unavailable, not installing tracing agent");
        }
        Matcher matcher = Pattern.compile("-javaagent:([^=]+).*").matcher(agentArgument);
        if (!matcher.matches()) {
            throw new RuntimeException("Unable to parse javaagent parameter: " + agentArgument);
        }
        File javaagentFile = new File(matcher.group(1));
        if (!javaagentFile.exists() && !javaagentFile.isFile()) {
            throw new RuntimeException("Unable to find javaagent file: " + javaagentFile);
        }
        bootstrapURL = javaagentFile.toURI().toURL();
        inst.appendToBootstrapClassLoaderSearch(new JarFile(javaagentFile));
        return bootstrapURL;
    }

    private static List<String> getVMArgumentsThroughReflection() {
        try {
            Object vmManagement;
            Class<?> managementFactoryHelperClass = AgentBootstrap.class.getClassLoader().loadClass("sun.management.ManagementFactoryHelper");
            Class<?> vmManagementClass = AgentBootstrap.class.getClassLoader().loadClass("sun.management.VMManagement");
            try {
                vmManagement = managementFactoryHelperClass.getDeclaredMethod("getVMManagement", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                Field field = managementFactoryHelperClass.getDeclaredField("jvm");
                field.setAccessible(true);
                vmManagement = field.get(null);
                field.setAccessible(false);
            }
            return (List)vmManagementClass.getMethod("getVmArguments", new Class[0]).invoke(vmManagement, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            try {
                Class<?> VMClass = AgentBootstrap.class.getClassLoader().loadClass("com.ibm.oti.vm.VM");
                String[] argArray = (String[])VMClass.getMethod("getVMArgs", new Class[0]).invoke(null, new Object[0]);
                return Arrays.asList(argArray);
            }
            catch (ReflectiveOperationException e1) {
                System.out.println("WARNING: Unable to get VM args through reflection.  A custom java.util.logging.LogManager may not work correctly");
                return ManagementFactory.getRuntimeMXBean().getInputArguments();
            }
        }
    }

    public static void main(String ... args) {
        try {
            System.out.println(AgentBootstrap.getAgentVersion());
        }
        catch (Exception e) {
            System.out.println("Failed to parse agent version");
            e.printStackTrace();
        }
    }

    public static String getAgentVersion() throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(AgentBootstrap.class.getResourceAsStream("/dd-java-agent.version"), StandardCharsets.UTF_8));){
            int c = reader.read();
            while (c != -1) {
                sb.append((char)c);
                c = reader.read();
            }
        }
        return sb.toString().trim();
    }
}

