/*
 * Decompiled with CFR 0.152.
 */
package com.github.seanroy.plugins;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEvents;
import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEventsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.util.CollectionUtils;
import com.github.seanroy.plugins.JsonUtil;
import com.github.seanroy.plugins.LambdaFunction;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractLambdaMojo
extends AbstractMojo {
    public static final String TRIG_INT_LABEL_CLOUDWATCH_EVENTS = "CloudWatch Events - Schedule";
    public static final String TRIG_INT_LABEL_DYNAMO_DB = "DynamoDB";
    public static final String TRIG_INT_LABEL_KINESIS = "Kinesis";
    public static final String TRIG_INT_LABEL_SNS = "SNS";
    public static final String TRIG_INT_LABEL_ALEXA_SK = "Alexa Skills Kit";
    @Parameter(property="accessKey", defaultValue="${accessKey}")
    public String accessKey;
    @Parameter(property="secretKey", defaultValue="${secretKey}")
    public String secretKey;
    @Parameter(property="functionCode", defaultValue="${functionCode}", required=true)
    public String functionCode;
    @Parameter(property="version", defaultValue="${version}", required=true)
    public String version;
    @Parameter(property="region", alias="region", defaultValue="us-east-1")
    public String regionName;
    @Parameter(property="s3Bucket", defaultValue="lambda-function-code")
    public String s3Bucket;
    @Parameter(property="runtime", defaultValue="java8")
    public String runtime;
    @Parameter(property="lambdaRoleArn", defaultValue="${lambdaRoleArn}", required=true)
    public String lambdaRoleArn;
    @Parameter(property="lambdaFunctionsJSON")
    public String lambdaFunctionsJSON;
    @Parameter(property="lambdaFunctions", defaultValue="${lambdaFunctions}")
    public List<LambdaFunction> lambdaFunctions;
    @Parameter(property="timeout", defaultValue="30")
    public int timeout;
    @Parameter(property="memorySize", defaultValue="1024")
    public int memorySize;
    @Parameter(property="vpcSecurityGroupIds", defaultValue="${vpcSecurityGroupIds}")
    public List<String> vpcSecurityGroupIds;
    @Parameter(property="vpcSubnetIds", defaultValue="${vpcSubnetIds}")
    public List<String> vpcSubnetIds;
    @Parameter(property="publish", defaultValue="true")
    public boolean publish;
    @Parameter(property="functionNameSuffix")
    public String functionNameSuffix;
    @Parameter(property="forceUpdate", defaultValue="false")
    public boolean forceUpdate;
    @Parameter(property="environmentVariables", defaultValue="${environmentVariables}")
    public Map<String, String> environmentVariables;
    @Parameter(property="passThrough")
    public String passThrough;
    public String fileName;
    public AWSCredentials credentials;
    public AmazonS3 s3Client;
    public AWSLambda lambdaClient;
    public AmazonSNS snsClient;
    public AmazonCloudWatchEvents eventsClient;
    public AmazonDynamoDBStreams dynamoDBStreamsClient;
    public AmazonKinesis kinesisClient;
    public AmazonCloudWatchEvents cloudWatchEventsClient;
    Function<AwsClientBuilder, AmazonWebServiceClient> clientFactory = b -> {
        Regions region = Regions.fromName((String)this.regionName);
        return (AmazonWebServiceClient)Optional.of(this.credentials).map(credentials -> b.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(credentials)).withRegion(region).build()).orElse(b.withRegion(region).withCredentials((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain()).build());
    };

    public void execute() throws MojoExecutionException {
        this.initAWSCredentials();
        this.initAWSClients();
        try {
            this.initFileName();
            this.initVersion();
            this.initLambdaFunctionsConfiguration();
            this.lambdaFunctions.forEach(lambdaFunction -> this.getLog().debug((CharSequence)lambdaFunction.toString()));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Initialization of configuration failed", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void initAWSCredentials() throws MojoExecutionException {
        DefaultAWSCredentialsProviderChain defaultChain = new DefaultAWSCredentialsProviderChain();
        if (this.accessKey != null && this.secretKey != null) {
            this.credentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
        } else if (defaultChain.getCredentials() != null) {
            this.credentials = defaultChain.getCredentials();
        }
        if (this.credentials == null) {
            this.getLog().error((CharSequence)"Unable to initialize AWS Credentials. Set BasicAWSCredentials with accessKey and secretKey or configure DefaultAWSCredentialsProviderChain");
            throw new MojoExecutionException("AWS Credentials config error");
        }
    }

    private void initFileName() {
        String pattern = Pattern.quote(File.separator);
        String[] pieces = this.functionCode.split(pattern);
        this.fileName = pieces[pieces.length - 1];
    }

    private void initVersion() {
        this.version = this.version.replace(".", "-");
    }

    private void initAWSClients() {
        this.s3Client = (AmazonS3)this.clientFactory.apply((AwsClientBuilder)AmazonS3ClientBuilder.standard());
        this.lambdaClient = (AWSLambda)this.clientFactory.apply((AwsClientBuilder)AWSLambdaClientBuilder.standard());
        this.snsClient = (AmazonSNS)this.clientFactory.apply((AwsClientBuilder)AmazonSNSClientBuilder.standard());
        this.eventsClient = (AmazonCloudWatchEvents)this.clientFactory.apply((AwsClientBuilder)AmazonCloudWatchEventsClientBuilder.standard());
        this.dynamoDBStreamsClient = (AmazonDynamoDBStreams)this.clientFactory.apply((AwsClientBuilder)AmazonDynamoDBStreamsClientBuilder.standard());
        this.kinesisClient = (AmazonKinesis)this.clientFactory.apply((AwsClientBuilder)AmazonKinesisClientBuilder.standard());
        this.cloudWatchEventsClient = (AmazonCloudWatchEvents)this.clientFactory.apply((AwsClientBuilder)AmazonCloudWatchEventsClientBuilder.standard());
    }

    private void initLambdaFunctionsConfiguration() throws MojoExecutionException, IOException {
        if (this.lambdaFunctionsJSON != null) {
            this.lambdaFunctions = (List)JsonUtil.fromJson(this.lambdaFunctionsJSON);
        }
        this.validate(this.lambdaFunctions);
        this.lambdaFunctions = this.lambdaFunctions.stream().map(lambdaFunction -> {
            String functionName = Optional.ofNullable(lambdaFunction.getFunctionName()).orElseThrow(() -> new IllegalArgumentException("Configuration error. LambdaFunction -> 'functionName' is required"));
            lambdaFunction.withFunctionName(this.addSuffix(functionName)).withHandler(Optional.ofNullable(lambdaFunction.getHandler()).orElseThrow(() -> new IllegalArgumentException("Configuration error. LambdaFunction -> 'handler' is required"))).withDescription(Optional.ofNullable(lambdaFunction.getDescription()).orElse("")).withTimeout(Optional.ofNullable(lambdaFunction.getTimeout()).orElse(this.timeout)).withMemorySize(Optional.ofNullable(lambdaFunction.getMemorySize()).orElse(this.memorySize)).withSubnetIds(Optional.ofNullable(this.vpcSubnetIds).orElse(new ArrayList())).withSecurityGroupsIds(Optional.ofNullable(this.vpcSecurityGroupIds).orElse(new ArrayList())).withVersion(this.version).withPublish(Optional.ofNullable(lambdaFunction.isPublish()).orElse(this.publish)).withAliases(this.aliases(lambdaFunction.isPublish())).withTriggers(Optional.ofNullable(lambdaFunction.getTriggers()).map(triggers -> triggers.stream().map(trigger -> {
                trigger.withRuleName(this.addSuffix(trigger.getRuleName()));
                trigger.withSNSTopic(this.addSuffix(trigger.getSNSTopic()));
                trigger.withDynamoDBTable(this.addSuffix(trigger.getDynamoDBTable()));
                return trigger;
            }).collect(Collectors.toList())).orElse(new ArrayList())).withEnvironmentVariables(this.environmentVariables((LambdaFunction)lambdaFunction));
            return lambdaFunction;
        }).collect(Collectors.toList());
    }

    private Map<String, String> environmentVariables(LambdaFunction lambdaFunction) {
        Map envVar0 = Optional.ofNullable(this.environmentVariables).orElse(new HashMap());
        Map envVar1 = Optional.ofNullable(lambdaFunction.getEnvironmentVariables()).orElse(new HashMap());
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Map passThroughEnvironmentVariables = (Map)new GsonBuilder().create().fromJson(Optional.ofNullable(this.passThrough).orElse("{}"), type);
        return Stream.of(envVar0, envVar1, passThroughEnvironmentVariables).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private String addSuffix(String functionName) {
        return Optional.ofNullable(this.functionNameSuffix).map(suffix -> Stream.of(functionName, suffix).collect(Collectors.joining())).orElse(functionName);
    }

    private List<String> aliases(boolean publish) {
        if (publish) {
            return Collections.singletonList(this.version);
        }
        return Collections.emptyList();
    }

    private void validate(List<LambdaFunction> lambdaFunctions) throws MojoExecutionException {
        if (CollectionUtils.isNullOrEmpty(lambdaFunctions)) {
            this.getLog().error((CharSequence)"At least one function has to be provided in configuration");
            throw new MojoExecutionException("Illegal configuration. Configuration for at least one Lambda function has to be provided");
        }
    }
}

