/*
 * Decompiled with CFR 0.152.
 */
package com.github.seanroy.plugins;

import com.amazonaws.services.cloudwatchevents.model.DeleteRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.ListRuleNamesByTargetRequest;
import com.amazonaws.services.cloudwatchevents.model.RemoveTargetsRequest;
import com.amazonaws.services.lambda.model.DeleteFunctionRequest;
import com.amazonaws.services.lambda.model.GetFunctionRequest;
import com.github.seanroy.plugins.AbstractLambdaMojo;
import com.github.seanroy.plugins.LambdaFunction;
import java.util.List;
import java.util.function.Function;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="delete-lambda")
public class DeleteLambdaMojo
extends AbstractLambdaMojo {
    private Function<LambdaFunction, LambdaFunction> deleteDynamoDBTrigger = lambdaFunction -> lambdaFunction;
    private Function<LambdaFunction, LambdaFunction> deleteKinesisTrigger = lambdaFunction -> lambdaFunction;
    private Function<LambdaFunction, LambdaFunction> deleteSNSTrigger = lambdaFunction -> lambdaFunction;
    private Function<LambdaFunction, LambdaFunction> deleteAlexaSkillsTrigger = lambdaFunction -> lambdaFunction;
    private Function<LambdaFunction, LambdaFunction> deleteCloudWatchEventRules = lambdaFunction -> {
        List existingRuleNames = this.cloudWatchEventsClient.listRuleNamesByTarget(new ListRuleNamesByTargetRequest().withTargetArn(lambdaFunction.getFunctionArn())).getRuleNames();
        existingRuleNames.stream().forEach(ern -> {
            this.getLog().info((CharSequence)("    Deleting CloudWatch Event Rule: " + ern));
            this.cloudWatchEventsClient.removeTargets(new RemoveTargetsRequest().withIds(new String[]{"1"}).withRule(ern));
            try {
                this.cloudWatchEventsClient.deleteRule(new DeleteRuleRequest().withName(ern));
            }
            catch (Exception e) {
                this.getLog().info((CharSequence)("    Could not delete orphaned rule: " + e.getMessage()));
            }
        });
        return lambdaFunction;
    };
    private Function<LambdaFunction, LambdaFunction> deleteFunction = context -> {
        String functionName = context.getFunctionName();
        DeleteFunctionRequest dfr = new DeleteFunctionRequest().withFunctionName(functionName);
        this.lambdaClient.deleteFunction(dfr);
        this.getLog().info((CharSequence)("Lambda function " + functionName + " successfully deleted."));
        this.s3Client.deleteObject(this.s3Bucket, this.fileName);
        this.getLog().info((CharSequence)"Lambda function code successfully removed from S3.");
        return context;
    };
    private Function<LambdaFunction, LambdaFunction> deleteTriggers = lambdaFunction -> this.deleteCloudWatchEventRules.andThen(this.deleteDynamoDBTrigger).andThen(this.deleteKinesisTrigger).andThen(this.deleteSNSTrigger).andThen(this.deleteAlexaSkillsTrigger).apply((LambdaFunction)lambdaFunction);

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            this.lambdaFunctions.forEach(context -> {
                try {
                    this.deleteTriggers.andThen(this.deleteFunction).apply(context.withFunctionArn(this.lambdaClient.getFunction(new GetFunctionRequest().withFunctionName(context.getFunctionName())).getConfiguration().getFunctionArn()));
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)e.getMessage());
                }
            });
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }
}

