/*
 * Decompiled with CFR 0.152.
 */
package com.github.seanroy.plugins;

import com.github.seanroy.plugins.Trigger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LambdaFunction {
    private String functionName;
    private String description;
    private String handler;
    private Integer memorySize;
    private Integer timeout;
    private String version;
    private List<String> securityGroupIds;
    private List<String> subnetIds;
    private List<String> aliases;
    private Integer keepAlive;
    private Boolean publish;
    private String functionArn;
    private List<Trigger> triggers;
    private Map<String, String> environmentVariables;
    private String qualifier;

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public Integer getMemorySize() {
        return this.memorySize;
    }

    public void setMemorySize(Integer memorySize) {
        this.memorySize = memorySize;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<String> getSecurityGroupIds() {
        if (this.securityGroupIds == null) {
            return new ArrayList<String>();
        }
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(List<String> securityGroupIds) {
        this.securityGroupIds = securityGroupIds;
    }

    public List<String> getSubnetIds() {
        if (this.subnetIds == null) {
            return new ArrayList<String>();
        }
        return this.subnetIds;
    }

    public void setSubnetIds(List<String> subnetIds) {
        this.subnetIds = subnetIds;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public Boolean isPublish() {
        return this.publish;
    }

    public void setPublish(boolean publish) {
        this.publish = publish;
    }

    public String getFunctionArn() {
        return this.functionArn;
    }

    public void setKeepAlive(Integer keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Integer getKeepAlive() {
        return this.keepAlive;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getUnqualifiedFunctionArn() {
        return Optional.ofNullable(this.functionArn).map(arn -> arn.replaceAll(this.functionName + ".*", this.functionName)).orElse(null);
    }

    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public void setFunctionArn(String functionArn) {
        this.functionArn = functionArn;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public LambdaFunction withDescription(String description) {
        this.description = description;
        return this;
    }

    public LambdaFunction withFunctionName(String functionName) {
        this.functionName = functionName;
        return this;
    }

    public LambdaFunction withHandler(String handler) {
        this.handler = handler;
        return this;
    }

    public LambdaFunction withMemorySize(Integer memorySize) {
        this.memorySize = memorySize;
        return this;
    }

    public LambdaFunction withSecurityGroupsIds(List<String> securityGroupsIds) {
        this.securityGroupIds = securityGroupsIds;
        return this;
    }

    public LambdaFunction withSubnetIds(List<String> subnetIds) {
        this.subnetIds = subnetIds;
        return this;
    }

    public LambdaFunction withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public LambdaFunction withVersion(String version) {
        this.version = version;
        return this;
    }

    public LambdaFunction withAliases(List<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public LambdaFunction withPublish(Boolean publish) {
        this.publish = publish;
        return this;
    }

    public LambdaFunction withFunctionArn(String functionArn) {
        this.functionArn = functionArn;
        return this;
    }

    public LambdaFunction withTriggers(List<Trigger> triggers) {
        this.triggers = triggers;
        return this;
    }

    public LambdaFunction withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public LambdaFunction withKeepAlive(Integer keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public LambdaFunction withQualifier(String qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    public String getKeepAliveRuleName() {
        return String.format("KEEP-ALIVE-%s", this.getFunctionName());
    }

    public String getKeepAliveScheduleExpression() {
        return String.format("rate(%d %s)", this.keepAlive, this.keepAlive > 1 ? "minutes" : "minute");
    }

    public String toString() {
        return "LambdaFunction{" + "functionName='" + this.functionName + '\'' + ", description='" + this.description + '\'' + ", handler='" + this.handler + '\'' + ", memorySize=" + this.memorySize + ", timeout=" + this.timeout + ", version='" + this.version + '\'' + ", securityGroupIds=" + this.securityGroupIds + ", subnetIds=" + this.subnetIds + ", aliases=" + this.aliases + ", publish=" + this.publish + ", triggers=" + this.triggers + ", keepAlive=" + this.keepAlive + ", environmentVariables=" + this.environmentVariables + '}';
    }
}

