/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastlefips.cert;

import com.itextpdf.bouncycastlefips.asn1.x509.AuthorityKeyIdentifierBCFips;
import com.itextpdf.bouncycastlefips.asn1.x509.SubjectKeyIdentifierBCFips;
import com.itextpdf.bouncycastlefips.asn1.x509.SubjectPublicKeyInfoBCFips;
import com.itextpdf.bouncycastlefips.operator.DigestCalculatorBCFips;
import com.itextpdf.commons.bouncycastle.asn1.x509.IAuthorityKeyIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.x509.ISubjectKeyIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.x509.ISubjectPublicKeyInfo;
import com.itextpdf.commons.bouncycastle.cert.IX509ExtensionUtils;
import com.itextpdf.commons.bouncycastle.operator.IDigestCalculator;
import java.util.Objects;
import org.bouncycastle.cert.X509ExtensionUtils;

public class X509ExtensionUtilsBCFips
implements IX509ExtensionUtils {
    private final X509ExtensionUtils extensionUtils;

    public X509ExtensionUtilsBCFips(X509ExtensionUtils extensionUtils) {
        this.extensionUtils = extensionUtils;
    }

    public X509ExtensionUtilsBCFips(IDigestCalculator digestCalculator) {
        this(new X509ExtensionUtils(((DigestCalculatorBCFips)digestCalculator).getDigestCalculator()));
    }

    public X509ExtensionUtils getExtensionUtils() {
        return this.extensionUtils;
    }

    public IAuthorityKeyIdentifier createAuthorityKeyIdentifier(ISubjectPublicKeyInfo publicKeyInfo) {
        return new AuthorityKeyIdentifierBCFips(this.extensionUtils.createAuthorityKeyIdentifier(((SubjectPublicKeyInfoBCFips)publicKeyInfo).getSubjectPublicKeyInfo()));
    }

    public ISubjectKeyIdentifier createSubjectKeyIdentifier(ISubjectPublicKeyInfo publicKeyInfo) {
        return new SubjectKeyIdentifierBCFips(this.extensionUtils.createSubjectKeyIdentifier(((SubjectPublicKeyInfoBCFips)publicKeyInfo).getSubjectPublicKeyInfo()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        X509ExtensionUtilsBCFips that = (X509ExtensionUtilsBCFips)o;
        return Objects.equals(this.extensionUtils, that.extensionUtils);
    }

    public int hashCode() {
        return Objects.hash(this.extensionUtils);
    }

    public String toString() {
        return this.extensionUtils.toString();
    }
}

