/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastlefips.cert.ocsp;

import com.itextpdf.bouncycastlefips.asn1.ASN1ObjectIdentifierBCFips;
import com.itextpdf.bouncycastlefips.asn1.x509.ExtensionBCFips;
import com.itextpdf.bouncycastlefips.cert.ocsp.ReqBCFips;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.x509.IExtension;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IOCSPReq;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IReq;
import java.io.IOException;
import java.util.Objects;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.Req;

public class OCSPReqBCFips
implements IOCSPReq {
    private final OCSPReq ocspReq;

    public OCSPReqBCFips(OCSPReq ocspReq) {
        this.ocspReq = ocspReq;
    }

    public OCSPReq getOcspReq() {
        return this.ocspReq;
    }

    public byte[] getEncoded() throws IOException {
        return this.ocspReq.getEncoded();
    }

    public IReq[] getRequestList() {
        Req[] reqs = this.ocspReq.getRequestList();
        IReq[] reqsBCFips = new IReq[reqs.length];
        for (int i = 0; i < reqs.length; ++i) {
            reqsBCFips[i] = new ReqBCFips(reqs[i]);
        }
        return reqsBCFips;
    }

    public IExtension getExtension(IASN1ObjectIdentifier objectIdentifier) {
        return new ExtensionBCFips(this.ocspReq.getExtension(((ASN1ObjectIdentifierBCFips)objectIdentifier).getASN1ObjectIdentifier()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCSPReqBCFips that = (OCSPReqBCFips)o;
        return Objects.equals(this.ocspReq, that.ocspReq);
    }

    public int hashCode() {
        return Objects.hash(this.ocspReq);
    }

    public String toString() {
        return this.ocspReq.toString();
    }
}

