/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastlefips.cert.ocsp;

import com.itextpdf.bouncycastlefips.asn1.x509.ExtensionsBCFips;
import com.itextpdf.bouncycastlefips.cert.ocsp.CertificateIDBCFips;
import com.itextpdf.bouncycastlefips.cert.ocsp.OCSPExceptionBCFips;
import com.itextpdf.bouncycastlefips.cert.ocsp.OCSPReqBCFips;
import com.itextpdf.commons.bouncycastle.asn1.x509.IExtensions;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ICertificateID;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IOCSPReq;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IOCSPReqBuilder;
import java.util.Objects;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;

public class OCSPReqBuilderBCFips
implements IOCSPReqBuilder {
    private final OCSPReqBuilder reqBuilder;

    public OCSPReqBuilderBCFips(OCSPReqBuilder reqBuilder) {
        this.reqBuilder = reqBuilder;
    }

    public OCSPReqBuilder getReqBuilder() {
        return this.reqBuilder;
    }

    public IOCSPReqBuilder setRequestExtensions(IExtensions extensions) {
        this.reqBuilder.setRequestExtensions(((ExtensionsBCFips)extensions).getExtensions());
        return this;
    }

    public IOCSPReqBuilder addRequest(ICertificateID certificateID) {
        this.reqBuilder.addRequest(((CertificateIDBCFips)certificateID).getCertificateID());
        return this;
    }

    public IOCSPReq build() throws OCSPExceptionBCFips {
        try {
            return new OCSPReqBCFips(this.reqBuilder.build());
        }
        catch (OCSPException e) {
            throw new OCSPExceptionBCFips(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCSPReqBuilderBCFips that = (OCSPReqBuilderBCFips)o;
        return Objects.equals(this.reqBuilder, that.reqBuilder);
    }

    public int hashCode() {
        return Objects.hash(this.reqBuilder);
    }

    public String toString() {
        return this.reqBuilder.toString();
    }
}

