/*
    This file is part of the iText (R) project.
    Copyright (c) 1998-2023 Apryse Group NV
    Authors: Apryse Software.

    This program is offered under a commercial and under the AGPL license.
    For commercial licensing, contact us at https://itextpdf.com/sales.  For AGPL licensing, see below.

    AGPL licensing:
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.itextpdf.bouncycastlefips.asn1.x509;

import com.itextpdf.bouncycastlefips.asn1.ASN1EncodableBCFips;
import com.itextpdf.commons.bouncycastle.asn1.x509.ICRLReason;

import org.bouncycastle.asn1.x509.CRLReason;

/**
 * Wrapper class for {@link CRLReason}.
 */
public class CRLReasonBCFips extends ASN1EncodableBCFips implements ICRLReason {
    private static final CRLReasonBCFips INSTANCE = new CRLReasonBCFips(null);

    private static final int KEY_COMPROMISE = CRLReason.keyCompromise;

    /**
     * Creates new wrapper instance for {@link CRLReason}.
     *
     * @param reason {@link CRLReason} to be wrapped
     */
    public CRLReasonBCFips(CRLReason reason) {
        super(reason);
    }

    /**
     * Gets wrapper instance.
     *
     * @return {@link CRLReasonBCFips} instance.
     */
    public static CRLReasonBCFips getInstance() {
        return INSTANCE;
    }

    /**
     * Gets actual org.bouncycastle object being wrapped.
     *
     * @return wrapped {@link CRLReason}.
     */
    public CRLReason getCRLReason() {
        return (CRLReason) getEncodable();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int getKeyCompromise() {
        return KEY_COMPROMISE;
    }
}
