/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastlefips.cert.ocsp;

import com.itextpdf.bouncycastlefips.cert.X509CertificateHolderBCFips;
import com.itextpdf.bouncycastlefips.cert.ocsp.OCSPExceptionBCFips;
import com.itextpdf.bouncycastlefips.cert.ocsp.SingleRespBCFips;
import com.itextpdf.bouncycastlefips.operator.ContentVerifierProviderBCFips;
import com.itextpdf.commons.bouncycastle.cert.IX509CertificateHolder;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IBasicOCSPResp;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ISingleResp;
import com.itextpdf.commons.bouncycastle.operator.IContentVerifierProvider;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.SingleResp;

public class BasicOCSPRespBCFips
implements IBasicOCSPResp {
    private final BasicOCSPResp basicOCSPResp;

    public BasicOCSPRespBCFips(BasicOCSPResp basicOCSPResp) {
        this.basicOCSPResp = basicOCSPResp;
    }

    public BasicOCSPResp getBasicOCSPResp() {
        return this.basicOCSPResp;
    }

    public ISingleResp[] getResponses() {
        SingleResp[] resps = this.basicOCSPResp.getResponses();
        ISingleResp[] respsBCFips = new ISingleResp[resps.length];
        for (int i = 0; i < respsBCFips.length; ++i) {
            respsBCFips[i] = new SingleRespBCFips(resps[i]);
        }
        return respsBCFips;
    }

    public boolean isSignatureValid(IContentVerifierProvider provider) throws OCSPExceptionBCFips {
        try {
            return this.basicOCSPResp.isSignatureValid(((ContentVerifierProviderBCFips)provider).getProvider());
        }
        catch (OCSPException e) {
            throw new OCSPExceptionBCFips(e);
        }
    }

    public IX509CertificateHolder[] getCerts() {
        X509CertificateHolder[] certs = this.basicOCSPResp.getCerts();
        IX509CertificateHolder[] certsBCFips = new IX509CertificateHolder[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            certsBCFips[i] = new X509CertificateHolderBCFips(certs[i]);
        }
        return certsBCFips;
    }

    public byte[] getEncoded() throws IOException {
        return this.basicOCSPResp.getEncoded();
    }

    public Date getProducedAt() {
        return this.basicOCSPResp.getProducedAt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicOCSPRespBCFips that = (BasicOCSPRespBCFips)o;
        return Objects.equals(this.basicOCSPResp, that.basicOCSPResp);
    }

    public int hashCode() {
        return Objects.hash(this.basicOCSPResp);
    }

    public String toString() {
        return this.basicOCSPResp.toString();
    }
}

