/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields.merging;

import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.merging.OnDuplicateFormFieldNameStrategy;
import java.util.HashMap;

public class AddIndexStrategy
implements OnDuplicateFormFieldNameStrategy {
    private static final String DEFAULT_SEPARATOR = "_";
    private final String separator;
    private final HashMap<String, Integer> countMap = new HashMap();
    private final String regexString;

    public AddIndexStrategy(String separator) {
        if (separator == null || separator.contains(".")) {
            throw new IllegalArgumentException("Separator should be a valid value. Values that are not allowed are null,empty string, or . ");
        }
        this.separator = separator;
        this.regexString = separator + "[0-9]+$";
    }

    public AddIndexStrategy() {
        this(DEFAULT_SEPARATOR);
    }

    @Override
    public boolean execute(PdfFormField firstField, PdfFormField secondField, boolean throwExceptionOnError) {
        if (firstField == null || secondField == null) {
            return false;
        }
        if (firstField.getFieldName() == null || secondField.getFieldName() == null) {
            return true;
        }
        String originalFieldName = firstField.getFieldName().toUnicodeString();
        String fieldToAddNewName = originalFieldName + this.separator + this.getNextIndex(originalFieldName);
        secondField.setFieldName(fieldToAddNewName);
        return true;
    }

    int getNextIndex(String name) {
        String normalizedName = name.replaceAll(this.regexString, "");
        Integer count = this.countMap.get(normalizedName);
        if (count == null) {
            count = 0;
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count + 1);
        this.countMap.put(normalizedName, count);
        return count;
    }
}

