/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.io.util.SystemUtil;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.crypto.IDecryptor;
import com.itextpdf.kernel.crypto.OutputStreamEncryption;
import com.itextpdf.kernel.crypto.securityhandler.PubKeySecurityHandler;
import com.itextpdf.kernel.crypto.securityhandler.PubSecHandlerUsingAes128;
import com.itextpdf.kernel.crypto.securityhandler.PubSecHandlerUsingAes256;
import com.itextpdf.kernel.crypto.securityhandler.PubSecHandlerUsingStandard128;
import com.itextpdf.kernel.crypto.securityhandler.PubSecHandlerUsingStandard40;
import com.itextpdf.kernel.crypto.securityhandler.SecurityHandler;
import com.itextpdf.kernel.crypto.securityhandler.StandardHandlerUsingAes128;
import com.itextpdf.kernel.crypto.securityhandler.StandardHandlerUsingAes256;
import com.itextpdf.kernel.crypto.securityhandler.StandardHandlerUsingStandard128;
import com.itextpdf.kernel.crypto.securityhandler.StandardHandlerUsingStandard40;
import com.itextpdf.kernel.crypto.securityhandler.StandardSecurityHandler;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.security.IExternalDecryptionProcess;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.cert.Certificate;

public class PdfEncryption
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = -6864863940808467156L;
    private static final int STANDARD_ENCRYPTION_40 = 2;
    private static final int STANDARD_ENCRYPTION_128 = 3;
    private static final int AES_128 = 4;
    private static final int AES_256 = 5;
    private static long seq = SystemUtil.getSystemTimeMillis();
    private int cryptoMode;
    private Long permissions;
    private boolean encryptMetadata;
    private boolean embeddedFilesOnly;
    private byte[] documentId;
    private SecurityHandler securityHandler;

    public PdfEncryption(byte[] userPassword, byte[] ownerPassword, int permissions, int encryptionType, byte[] documentId) {
        super(new PdfDictionary());
        this.documentId = documentId;
        int revision = this.setCryptoMode(encryptionType);
        switch (revision) {
            case 2: {
                StandardHandlerUsingStandard40 handlerStd40 = new StandardHandlerUsingStandard40((PdfDictionary)this.getPdfObject(), userPassword, ownerPassword, permissions, this.encryptMetadata, this.embeddedFilesOnly, documentId);
                this.permissions = handlerStd40.getPermissions();
                this.securityHandler = handlerStd40;
                break;
            }
            case 3: {
                StandardHandlerUsingStandard128 handlerStd128 = new StandardHandlerUsingStandard128((PdfDictionary)this.getPdfObject(), userPassword, ownerPassword, permissions, this.encryptMetadata, this.embeddedFilesOnly, documentId);
                this.permissions = handlerStd128.getPermissions();
                this.securityHandler = handlerStd128;
                break;
            }
            case 4: {
                StandardHandlerUsingAes128 handlerAes128 = new StandardHandlerUsingAes128((PdfDictionary)this.getPdfObject(), userPassword, ownerPassword, permissions, this.encryptMetadata, this.embeddedFilesOnly, documentId);
                this.permissions = handlerAes128.getPermissions();
                this.securityHandler = handlerAes128;
                break;
            }
            case 5: {
                StandardHandlerUsingAes256 handlerAes256 = new StandardHandlerUsingAes256((PdfDictionary)this.getPdfObject(), userPassword, ownerPassword, permissions, this.encryptMetadata, this.embeddedFilesOnly);
                this.permissions = handlerAes256.getPermissions();
                this.securityHandler = handlerAes256;
            }
        }
    }

    public PdfEncryption(Certificate[] certs, int[] permissions, int encryptionType) {
        super(new PdfDictionary());
        int revision = this.setCryptoMode(encryptionType);
        switch (revision) {
            case 2: {
                this.securityHandler = new PubSecHandlerUsingStandard40((PdfDictionary)this.getPdfObject(), certs, permissions, this.encryptMetadata, this.embeddedFilesOnly);
                break;
            }
            case 3: {
                this.securityHandler = new PubSecHandlerUsingStandard128((PdfDictionary)this.getPdfObject(), certs, permissions, this.encryptMetadata, this.embeddedFilesOnly);
                break;
            }
            case 4: {
                this.securityHandler = new PubSecHandlerUsingAes128((PdfDictionary)this.getPdfObject(), certs, permissions, this.encryptMetadata, this.embeddedFilesOnly);
                break;
            }
            case 5: {
                this.securityHandler = new PubSecHandlerUsingAes256((PdfDictionary)this.getPdfObject(), certs, permissions, this.encryptMetadata, this.embeddedFilesOnly);
            }
        }
    }

    public PdfEncryption(PdfDictionary pdfDict, byte[] password, byte[] documentId) {
        super(pdfDict);
        this.setForbidRelease();
        this.documentId = documentId;
        int revision = this.readAndSetCryptoModeForStdHandler(pdfDict);
        switch (revision) {
            case 2: {
                StandardHandlerUsingStandard40 handlerStd40 = new StandardHandlerUsingStandard40((PdfDictionary)this.getPdfObject(), password, documentId, this.encryptMetadata);
                this.permissions = handlerStd40.getPermissions();
                this.securityHandler = handlerStd40;
                break;
            }
            case 3: {
                StandardHandlerUsingStandard128 handlerStd128 = new StandardHandlerUsingStandard128((PdfDictionary)this.getPdfObject(), password, documentId, this.encryptMetadata);
                this.permissions = handlerStd128.getPermissions();
                this.securityHandler = handlerStd128;
                break;
            }
            case 4: {
                StandardHandlerUsingAes128 handlerAes128 = new StandardHandlerUsingAes128((PdfDictionary)this.getPdfObject(), password, documentId, this.encryptMetadata);
                this.permissions = handlerAes128.getPermissions();
                this.securityHandler = handlerAes128;
                break;
            }
            case 5: {
                StandardHandlerUsingAes256 aes256Handler = new StandardHandlerUsingAes256((PdfDictionary)this.getPdfObject(), password);
                this.permissions = aes256Handler.getPermissions();
                this.encryptMetadata = aes256Handler.isEncryptMetadata();
                this.securityHandler = aes256Handler;
            }
        }
    }

    public PdfEncryption(PdfDictionary pdfDict, Key certificateKey, Certificate certificate, String certificateKeyProvider, IExternalDecryptionProcess externalDecryptionProcess) {
        super(pdfDict);
        this.setForbidRelease();
        int revision = this.readAndSetCryptoModeForPubSecHandler(pdfDict);
        switch (revision) {
            case 2: {
                this.securityHandler = new PubSecHandlerUsingStandard40((PdfDictionary)this.getPdfObject(), certificateKey, certificate, certificateKeyProvider, externalDecryptionProcess, this.encryptMetadata);
                break;
            }
            case 3: {
                this.securityHandler = new PubSecHandlerUsingStandard128((PdfDictionary)this.getPdfObject(), certificateKey, certificate, certificateKeyProvider, externalDecryptionProcess, this.encryptMetadata);
                break;
            }
            case 4: {
                this.securityHandler = new PubSecHandlerUsingAes128((PdfDictionary)this.getPdfObject(), certificateKey, certificate, certificateKeyProvider, externalDecryptionProcess, this.encryptMetadata);
                break;
            }
            case 5: {
                this.securityHandler = new PubSecHandlerUsingAes256((PdfDictionary)this.getPdfObject(), certificateKey, certificate, certificateKeyProvider, externalDecryptionProcess, this.encryptMetadata);
            }
        }
    }

    public static byte[] generateNewDocumentId() {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new PdfException("PdfEncryption exception.", e);
        }
        long time = SystemUtil.getSystemTimeMillis();
        long mem = SystemUtil.getFreeMemory();
        String s = time + "+" + mem + "+" + seq++;
        return md5.digest(s.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static PdfObject createInfoId(byte[] id, boolean modified) {
        if (modified) {
            return PdfEncryption.createInfoId(id, PdfEncryption.generateNewDocumentId());
        }
        return PdfEncryption.createInfoId(id, id);
    }

    public static PdfObject createInfoId(byte[] firstId, byte[] secondId) {
        int k;
        if (firstId.length < 16) {
            firstId = PdfEncryption.padByteArrayTo16(firstId);
        }
        if (secondId.length < 16) {
            secondId = PdfEncryption.padByteArrayTo16(secondId);
        }
        ByteBuffer buf = new ByteBuffer(90);
        buf.append(91).append(60);
        for (k = 0; k < firstId.length; ++k) {
            buf.appendHex(firstId[k]);
        }
        buf.append(62).append(60);
        for (k = 0; k < secondId.length; ++k) {
            buf.appendHex(secondId[k]);
        }
        buf.append(62).append(93);
        return new PdfLiteral(buf.toByteArray());
    }

    private static byte[] padByteArrayTo16(byte[] documentId) {
        byte[] paddingBytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        System.arraycopy(documentId, 0, paddingBytes, 0, documentId.length);
        return paddingBytes;
    }

    public Long getPermissions() {
        return this.permissions;
    }

    public int getCryptoMode() {
        return this.cryptoMode;
    }

    public boolean isMetadataEncrypted() {
        return this.encryptMetadata;
    }

    public boolean isEmbeddedFilesOnly() {
        return this.embeddedFilesOnly;
    }

    public byte[] getDocumentId() {
        return this.documentId;
    }

    public void setHashKeyForNextObject(int objNumber, int objGeneration) {
        this.securityHandler.setHashKeyForNextObject(objNumber, objGeneration);
    }

    public OutputStreamEncryption getEncryptionStream(OutputStream os) {
        return this.securityHandler.getEncryptionStream(os);
    }

    public byte[] encryptByteArray(byte[] b) {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        OutputStreamEncryption ose = this.getEncryptionStream(ba);
        try {
            ose.write(b);
        }
        catch (IOException e) {
            throw new PdfException("PdfEncryption exception.", e);
        }
        ose.finish();
        return ba.toByteArray();
    }

    public byte[] decryptByteArray(byte[] b) {
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            IDecryptor dec = this.securityHandler.getDecryptor();
            byte[] b2 = dec.update(b, 0, b.length);
            if (b2 != null) {
                ba.write(b2);
            }
            if ((b2 = dec.finish()) != null) {
                ba.write(b2);
            }
            return ba.toByteArray();
        }
        catch (IOException e) {
            throw new PdfException("PdfEncryption exception.", e);
        }
    }

    public boolean isOpenedWithFullPermission() {
        if (this.securityHandler instanceof PubKeySecurityHandler) {
            return true;
        }
        if (this.securityHandler instanceof StandardSecurityHandler) {
            return ((StandardSecurityHandler)this.securityHandler).isUsedOwnerPassword();
        }
        return true;
    }

    public byte[] computeUserPassword(byte[] ownerPassword) {
        byte[] userPassword = null;
        if (this.securityHandler instanceof StandardHandlerUsingStandard40) {
            userPassword = ((StandardHandlerUsingStandard40)this.securityHandler).computeUserPassword(ownerPassword, (PdfDictionary)this.getPdfObject());
        }
        return userPassword;
    }

    @Override
    public void flush() {
        super.flush();
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    private void setKeyLength(int keyLength) {
        if (keyLength != 40) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Length, new PdfNumber(keyLength));
        }
    }

    private int setCryptoMode(int mode) {
        return this.setCryptoMode(mode, 0);
    }

    private int setCryptoMode(int mode, int length) {
        int revision;
        this.cryptoMode = mode;
        this.encryptMetadata = (mode & 8) != 8;
        this.embeddedFilesOnly = (mode & 0x18) == 24;
        switch (mode &= 7) {
            case 0: {
                this.encryptMetadata = true;
                this.embeddedFilesOnly = false;
                this.setKeyLength(40);
                revision = 2;
                break;
            }
            case 1: {
                this.embeddedFilesOnly = false;
                if (length > 0) {
                    this.setKeyLength(length);
                } else {
                    this.setKeyLength(128);
                }
                revision = 3;
                break;
            }
            case 2: {
                this.setKeyLength(128);
                revision = 4;
                break;
            }
            case 3: {
                this.setKeyLength(256);
                revision = 5;
                break;
            }
            default: {
                throw new PdfException("No valid encryption mode.");
            }
        }
        return revision;
    }

    private int readAndSetCryptoModeForStdHandler(PdfDictionary encDict) {
        int cryptoMode;
        int length = 0;
        PdfNumber rValue = encDict.getAsNumber(PdfName.R);
        if (rValue == null) {
            throw new PdfException("Illegal R value.");
        }
        int revision = rValue.intValue();
        switch (revision) {
            case 2: {
                cryptoMode = 0;
                break;
            }
            case 3: {
                PdfNumber lengthValue = encDict.getAsNumber(PdfName.Length);
                if (lengthValue == null) {
                    throw new PdfException("Illegal length value.");
                }
                length = lengthValue.intValue();
                if (length > 128 || length < 40 || length % 8 != 0) {
                    throw new PdfException("Illegal length value.");
                }
                cryptoMode = 1;
                break;
            }
            case 4: {
                PdfDictionary dic = (PdfDictionary)encDict.get(PdfName.CF);
                if (dic == null) {
                    throw new PdfException("/CF not found (encryption)");
                }
                if ((dic = (PdfDictionary)dic.get(PdfName.StdCF)) == null) {
                    throw new PdfException("/StdCF not found (encryption)");
                }
                if (PdfName.V2.equals(dic.get(PdfName.CFM))) {
                    cryptoMode = 1;
                } else if (PdfName.AESV2.equals(dic.get(PdfName.CFM))) {
                    cryptoMode = 2;
                } else {
                    throw new PdfException("No compatible encryption found.");
                }
                PdfBoolean em = encDict.getAsBoolean(PdfName.EncryptMetadata);
                if (em == null || em.getValue()) break;
                cryptoMode |= 8;
                break;
            }
            case 5: {
                cryptoMode = 3;
                PdfBoolean em5 = encDict.getAsBoolean(PdfName.EncryptMetadata);
                if (em5 == null || em5.getValue()) break;
                cryptoMode |= 8;
                break;
            }
            default: {
                throw new PdfException("Unknown encryption type R == {0}.").setMessageParams(rValue);
            }
        }
        revision = this.setCryptoMode(cryptoMode, length);
        return revision;
    }

    private int readAndSetCryptoModeForPubSecHandler(PdfDictionary encDict) {
        int cryptoMode;
        int length = 0;
        PdfNumber vValue = encDict.getAsNumber(PdfName.V);
        if (vValue == null) {
            throw new PdfException("Illegal V value.");
        }
        int v = vValue.intValue();
        switch (v) {
            case 1: {
                cryptoMode = 0;
                length = 40;
                break;
            }
            case 2: {
                PdfNumber lengthValue = encDict.getAsNumber(PdfName.Length);
                if (lengthValue == null) {
                    throw new PdfException("Illegal length value.");
                }
                length = lengthValue.intValue();
                if (length > 128 || length < 40 || length % 8 != 0) {
                    throw new PdfException("Illegal length value.");
                }
                cryptoMode = 1;
                break;
            }
            case 4: 
            case 5: {
                PdfDictionary dic = encDict.getAsDictionary(PdfName.CF);
                if (dic == null) {
                    throw new PdfException("/CF not found (encryption)");
                }
                if ((dic = (PdfDictionary)dic.get(PdfName.DefaultCryptFilter)) == null) {
                    throw new PdfException("/DefaultCryptFilter not found (encryption).");
                }
                if (PdfName.V2.equals(dic.get(PdfName.CFM))) {
                    cryptoMode = 1;
                    length = 128;
                } else if (PdfName.AESV2.equals(dic.get(PdfName.CFM))) {
                    cryptoMode = 2;
                    length = 128;
                } else if (PdfName.AESV3.equals(dic.get(PdfName.CFM))) {
                    cryptoMode = 3;
                    length = 256;
                } else {
                    throw new PdfException("No compatible encryption found.");
                }
                PdfBoolean em = dic.getAsBoolean(PdfName.EncryptMetadata);
                if (em == null || em.getValue()) break;
                cryptoMode |= 8;
                break;
            }
            default: {
                throw new PdfException("Unknown encryption type V == {0}.", vValue);
            }
        }
        return this.setCryptoMode(cryptoMode, length);
    }
}

