/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.tagging.IPdfStructElem;
import com.itextpdf.kernel.pdf.tagging.ParentTreeHandler;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.StructureTreeCopier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PdfStructTreeRoot
extends PdfObjectWrapper<PdfDictionary>
implements IPdfStructElem {
    private static final long serialVersionUID = 2168384302241193868L;
    private ParentTreeHandler parentTreeHandler;

    public PdfStructTreeRoot(PdfDocument document) {
        this(new PdfDictionary().makeIndirect(document));
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.StructTreeRoot);
    }

    public PdfStructTreeRoot(PdfDictionary pdfObject) {
        super(pdfObject);
        PdfStructTreeRoot.ensureObjectIsAddedToDocument(pdfObject);
        this.setForbidRelease();
        this.parentTreeHandler = new ParentTreeHandler(this);
        this.getRoleMap();
    }

    public PdfStructElem addKid(PdfStructElem structElem) {
        return this.addKid(-1, structElem);
    }

    public PdfStructElem addKid(int index, PdfStructElem structElem) {
        this.addKidObject(index, (PdfDictionary)structElem.getPdfObject());
        return structElem;
    }

    @Override
    public IPdfStructElem getParent() {
        return null;
    }

    @Override
    public List<IPdfStructElem> getKids() {
        PdfObject k = ((PdfDictionary)this.getPdfObject()).get(PdfName.K);
        ArrayList<IPdfStructElem> kids = new ArrayList<IPdfStructElem>();
        if (k != null) {
            if (k.isArray()) {
                PdfArray a = (PdfArray)k;
                for (int i = 0; i < a.size(); ++i) {
                    this.ifKidIsStructElementAddToList(a.get(i), kids);
                }
            } else {
                this.ifKidIsStructElementAddToList(k, kids);
            }
        }
        return kids;
    }

    public PdfArray getKidsObject() {
        PdfArray k = null;
        PdfObject kObj = ((PdfDictionary)this.getPdfObject()).get(PdfName.K);
        if (kObj != null && kObj.isArray()) {
            k = (PdfArray)kObj;
        }
        if (k == null) {
            k = new PdfArray();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.K, k);
            this.setModified();
            if (kObj != null) {
                k.add(kObj);
            }
        }
        return k;
    }

    public PdfDictionary getRoleMap() {
        PdfDictionary roleMap = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.RoleMap);
        if (roleMap == null) {
            roleMap = new PdfDictionary();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.RoleMap, roleMap);
            this.setModified();
        }
        return roleMap;
    }

    public void createParentTreeEntryForPage(PdfPage page) {
        this.getParentTreeHandler().createParentTreeEntryForPage(page);
    }

    public Collection<PdfMcr> getPageMarkedContentReferences(PdfPage page) {
        Map<Integer, PdfMcr> pageMcrs = this.getParentTreeHandler().getPageMarkedContentReferences(page);
        return pageMcrs != null ? Collections.unmodifiableCollection(pageMcrs.values()) : null;
    }

    public PdfMcr findMcrByMcid(PdfDictionary pageDict, int mcid) {
        return this.getParentTreeHandler().findMcrByMcid(pageDict, mcid);
    }

    public PdfObjRef findObjRefByStructParentIndex(PdfDictionary pageDict, int structParentIndex) {
        return this.getParentTreeHandler().findObjRefByStructParentIndex(pageDict, structParentIndex);
    }

    @Override
    public PdfName getRole() {
        return null;
    }

    @Override
    public void flush() {
        for (int i = 0; i < this.getDocument().getNumberOfPages(); ++i) {
            this.createParentTreeEntryForPage(this.getDocument().getPage(i + 1));
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.ParentTree, this.getParentTreeHandler().buildParentTree());
        ((PdfDictionary)this.getPdfObject()).put(PdfName.ParentTreeNextKey, new PdfNumber(this.getDocument().getNextStructParentIndex()));
        if (!this.getDocument().isAppendMode()) {
            this.flushAllKids(this);
        }
        super.flush();
    }

    public void copyTo(PdfDocument destDocument, Map<PdfPage, PdfPage> page2page) {
        StructureTreeCopier.copyTo(destDocument, page2page, this.getDocument());
    }

    public void copyTo(PdfDocument destDocument, int insertBeforePage, Map<PdfPage, PdfPage> page2page) {
        StructureTreeCopier.copyTo(destDocument, insertBeforePage, page2page, this.getDocument());
    }

    public int getParentTreeNextKey() {
        return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.ParentTreeNextKey).intValue();
    }

    public int getNextMcidForPage(PdfPage page) {
        return this.getParentTreeHandler().getNextMcidForPage(page);
    }

    public PdfDocument getDocument() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
    }

    ParentTreeHandler getParentTreeHandler() {
        return this.parentTreeHandler;
    }

    void addKidObject(int index, PdfDictionary structElem) {
        if (index == -1) {
            this.getKidsObject().add(structElem);
        } else {
            this.getKidsObject().add(index, structElem);
        }
        if (PdfStructElem.isStructElem(structElem)) {
            structElem.put(PdfName.P, (PdfObject)this.getPdfObject());
        }
        this.setModified();
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    private void flushAllKids(IPdfStructElem elem) {
        for (IPdfStructElem kid : elem.getKids()) {
            if (!(kid instanceof PdfStructElem) || ((PdfStructElem)kid).isFlushed()) continue;
            this.flushAllKids(kid);
            ((PdfStructElem)kid).flush();
        }
    }

    private void ifKidIsStructElementAddToList(PdfObject kid, List<IPdfStructElem> kids) {
        if (kid.isFlushed()) {
            kids.add(null);
        } else if (kid.getType() == 3 && PdfStructElem.isStructElem((PdfDictionary)kid)) {
            kids.add(new PdfStructElem((PdfDictionary)kid));
        }
    }
}

