/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.data;

import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.LineSegment;
import com.itextpdf.kernel.geom.Matrix;
import com.itextpdf.kernel.geom.Vector;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.parser.data.AbstractRenderInfo;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class TextRenderInfo
extends AbstractRenderInfo {
    private final PdfString string;
    private String text = null;
    private final Matrix textToUserSpaceTransformMatrix;
    private final Matrix textMatrix;
    private float unscaledWidth = Float.NaN;
    private double[] fontMatrix = null;
    private final List<CanvasTag> canvasTagHierarchy;

    public TextRenderInfo(PdfString str, CanvasGraphicsState gs, Matrix textMatrix, Stack<CanvasTag> canvasTagHierarchy) {
        super(gs);
        this.string = str;
        this.textToUserSpaceTransformMatrix = textMatrix.multiply(gs.getCtm());
        this.textMatrix = textMatrix;
        this.canvasTagHierarchy = Collections.unmodifiableList(new ArrayList<CanvasTag>(canvasTagHierarchy));
        this.fontMatrix = gs.getFont().getFontMatrix();
    }

    private TextRenderInfo(TextRenderInfo parent, PdfString str, float horizontalOffset) {
        super(parent.gs);
        this.string = str;
        Matrix offsetMatrix = new Matrix(horizontalOffset, 0.0f);
        this.textToUserSpaceTransformMatrix = offsetMatrix.multiply(parent.textToUserSpaceTransformMatrix);
        this.textMatrix = offsetMatrix.multiply(parent.textMatrix);
        this.canvasTagHierarchy = parent.canvasTagHierarchy;
        this.fontMatrix = parent.gs.getFont().getFontMatrix();
    }

    public String getText() {
        this.checkGraphicsState();
        if (this.text == null) {
            GlyphLine gl = this.gs.getFont().decodeIntoGlyphLine(this.string);
            if (!this.isReversedChars()) {
                this.text = gl.toUnicodeString(gl.start, gl.end);
            } else {
                StringBuilder sb = new StringBuilder(gl.end - gl.start);
                for (int i = gl.end - 1; i >= gl.start; --i) {
                    sb.append(gl.get(i).getUnicodeChars());
                }
                this.text = sb.toString();
            }
        }
        return this.text;
    }

    public PdfString getPdfString() {
        return this.string;
    }

    public Matrix getTextMatrix() {
        return this.textMatrix;
    }

    public boolean hasMcid(int mcid) {
        return this.hasMcid(mcid, false);
    }

    public boolean hasMcid(int mcid, boolean checkTheTopmostLevelOnly) {
        if (checkTheTopmostLevelOnly) {
            if (this.canvasTagHierarchy != null) {
                int infoMcid = this.getMcid();
                return infoMcid != -1 && infoMcid == mcid;
            }
        } else {
            for (CanvasTag tag : this.canvasTagHierarchy) {
                if (!tag.hasMcid() || tag.getMcid() != mcid) continue;
                return true;
            }
        }
        return false;
    }

    public int getMcid() {
        for (CanvasTag tag : this.canvasTagHierarchy) {
            if (!tag.hasMcid()) continue;
            return tag.getMcid();
        }
        return -1;
    }

    public LineSegment getBaseline() {
        this.checkGraphicsState();
        return this.getUnscaledBaselineWithOffset(0.0f + this.gs.getTextRise()).transformBy(this.textToUserSpaceTransformMatrix);
    }

    public LineSegment getUnscaledBaseline() {
        this.checkGraphicsState();
        return this.getUnscaledBaselineWithOffset(0.0f + this.gs.getTextRise());
    }

    public LineSegment getAscentLine() {
        this.checkGraphicsState();
        return this.getUnscaledBaselineWithOffset(this.getAscentDescent()[0] + this.gs.getTextRise()).transformBy(this.textToUserSpaceTransformMatrix);
    }

    public LineSegment getDescentLine() {
        this.checkGraphicsState();
        return this.getUnscaledBaselineWithOffset(this.getAscentDescent()[1] + this.gs.getTextRise()).transformBy(this.textToUserSpaceTransformMatrix);
    }

    public PdfFont getFont() {
        this.checkGraphicsState();
        return this.gs.getFont();
    }

    public float getRise() {
        this.checkGraphicsState();
        if (this.gs.getTextRise() == 0.0f) {
            return 0.0f;
        }
        return this.convertHeightFromTextSpaceToUserSpace(this.gs.getTextRise());
    }

    public List<TextRenderInfo> getCharacterRenderInfos() {
        this.checkGraphicsState();
        ArrayList<TextRenderInfo> rslt = new ArrayList<TextRenderInfo>(this.string.getValue().length());
        PdfString[] strings = this.splitString(this.string);
        float totalWidth = 0.0f;
        for (PdfString str : strings) {
            float[] widthAndWordSpacing = this.getWidthAndWordSpacing(str);
            TextRenderInfo subInfo = new TextRenderInfo(this, str, totalWidth);
            rslt.add(subInfo);
            totalWidth += (widthAndWordSpacing[0] * this.gs.getFontSize() + this.gs.getCharSpacing() + widthAndWordSpacing[1]) * (this.gs.getHorizontalScaling() / 100.0f);
        }
        for (TextRenderInfo tri : rslt) {
            tri.getUnscaledWidth();
        }
        return rslt;
    }

    public float getSingleSpaceWidth() {
        return this.convertWidthFromTextSpaceToUserSpace(this.getUnscaledFontSpaceWidth());
    }

    public int getTextRenderMode() {
        this.checkGraphicsState();
        return this.gs.getTextRenderingMode();
    }

    public Color getFillColor() {
        this.checkGraphicsState();
        return this.gs.getFillColor();
    }

    public Color getStrokeColor() {
        this.checkGraphicsState();
        return this.gs.getStrokeColor();
    }

    public float getFontSize() {
        this.checkGraphicsState();
        return this.gs.getFontSize();
    }

    public float getHorizontalScaling() {
        this.checkGraphicsState();
        return this.gs.getHorizontalScaling();
    }

    public float getCharSpacing() {
        this.checkGraphicsState();
        return this.gs.getCharSpacing();
    }

    public float getWordSpacing() {
        this.checkGraphicsState();
        return this.gs.getWordSpacing();
    }

    public float getLeading() {
        this.checkGraphicsState();
        return this.gs.getLeading();
    }

    public String getActualText() {
        CanvasTag tag;
        String lastActualText = null;
        Iterator<CanvasTag> iterator = this.canvasTagHierarchy.iterator();
        while (iterator.hasNext() && (lastActualText = (tag = iterator.next()).getActualText()) == null) {
        }
        return lastActualText;
    }

    public String getExpansionText() {
        CanvasTag tag;
        String expansionText = null;
        Iterator<CanvasTag> iterator = this.canvasTagHierarchy.iterator();
        while (iterator.hasNext() && (expansionText = (tag = iterator.next()).getExpansionText()) == null) {
        }
        return expansionText;
    }

    public boolean isReversedChars() {
        for (CanvasTag tag : this.canvasTagHierarchy) {
            if (tag == null || !PdfName.ReversedChars.equals(tag.getRole())) continue;
            return true;
        }
        return false;
    }

    public List<CanvasTag> getCanvasTagHierarchy() {
        return this.canvasTagHierarchy;
    }

    public float getUnscaledWidth() {
        if (Float.isNaN(this.unscaledWidth)) {
            this.unscaledWidth = this.getPdfStringWidth(this.string, false);
        }
        return this.unscaledWidth;
    }

    private LineSegment getUnscaledBaselineWithOffset(float yOffset) {
        this.checkGraphicsState();
        String unicodeStr = this.string.toUnicodeString();
        float correctedUnscaledWidth = this.getUnscaledWidth() - (this.gs.getCharSpacing() + (unicodeStr.length() > 0 && unicodeStr.charAt(unicodeStr.length() - 1) == ' ' ? this.gs.getWordSpacing() : 0.0f)) * (this.gs.getHorizontalScaling() / 100.0f);
        return new LineSegment(new Vector(0.0f, yOffset, 1.0f), new Vector(correctedUnscaledWidth, yOffset, 1.0f));
    }

    private float convertWidthFromTextSpaceToUserSpace(float width) {
        LineSegment textSpace = new LineSegment(new Vector(0.0f, 0.0f, 1.0f), new Vector(width, 0.0f, 1.0f));
        LineSegment userSpace = textSpace.transformBy(this.textToUserSpaceTransformMatrix);
        return userSpace.getLength();
    }

    private float convertHeightFromTextSpaceToUserSpace(float height) {
        LineSegment textSpace = new LineSegment(new Vector(0.0f, 0.0f, 1.0f), new Vector(0.0f, height, 1.0f));
        LineSegment userSpace = textSpace.transformBy(this.textToUserSpaceTransformMatrix);
        return userSpace.getLength();
    }

    private float getUnscaledFontSpaceWidth() {
        this.checkGraphicsState();
        char charToUse = ' ';
        if (this.gs.getFont().getWidth(charToUse) == 0) {
            return (float)this.gs.getFont().getFontProgram().getAvgWidth() / 1000.0f;
        }
        return this.getStringWidth(String.valueOf(charToUse));
    }

    private float getStringWidth(String string) {
        this.checkGraphicsState();
        float totalWidth = 0.0f;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            float w = (float)((double)this.gs.getFont().getWidth(c) * this.fontMatrix[0]);
            float wordSpacing = c == ' ' ? this.gs.getWordSpacing() : 0.0f;
            totalWidth += (w * this.gs.getFontSize() + this.gs.getCharSpacing() + wordSpacing) * this.gs.getHorizontalScaling() / 100.0f;
        }
        return totalWidth;
    }

    private float getPdfStringWidth(PdfString string, boolean singleCharString) {
        this.checkGraphicsState();
        if (singleCharString) {
            float[] widthAndWordSpacing = this.getWidthAndWordSpacing(string);
            return (widthAndWordSpacing[0] * this.gs.getFontSize() + this.gs.getCharSpacing() + widthAndWordSpacing[1]) * this.gs.getHorizontalScaling() / 100.0f;
        }
        float totalWidth = 0.0f;
        for (PdfString str : this.splitString(string)) {
            totalWidth += this.getPdfStringWidth(str, true);
        }
        return totalWidth;
    }

    private float[] getWidthAndWordSpacing(PdfString string) {
        this.checkGraphicsState();
        float[] result = new float[]{(float)((double)this.gs.getFont().getContentWidth(string) * this.fontMatrix[0]), " ".equals(string.getValue()) ? this.gs.getWordSpacing() : 0.0f};
        return result;
    }

    private int getCharCode(String string) {
        try {
            byte[] b = string.getBytes("UTF-16BE");
            int value = 0;
            for (int i = 0; i < b.length - 1; ++i) {
                value += b[i] & 0xFF;
                value <<= 8;
            }
            if (b.length > 0) {
                value += b[b.length - 1] & 0xFF;
            }
            return value;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return 0;
        }
    }

    private PdfString[] splitString(PdfString string) {
        this.checkGraphicsState();
        ArrayList<PdfString> strings = new ArrayList<PdfString>();
        String stringValue = string.getValue();
        for (int i = 0; i < stringValue.length(); ++i) {
            PdfString newString = new PdfString(stringValue.substring(i, i + 1), string.getEncoding());
            String text = this.gs.getFont().decode(newString);
            if (text.length() == 0 && i < stringValue.length() - 1) {
                newString = new PdfString(stringValue.substring(i, i + 2), string.getEncoding());
                ++i;
            }
            strings.add(newString);
        }
        return strings.toArray(new PdfString[strings.size()]);
    }

    private float[] getAscentDescent() {
        this.checkGraphicsState();
        float ascent = this.gs.getFont().getFontProgram().getFontMetrics().getTypoAscender();
        float descent = this.gs.getFont().getFontProgram().getFontMetrics().getTypoDescender();
        if (descent > 0.0f) {
            descent = -descent;
        }
        float scale = ascent - descent < 700.0f ? ascent - descent : 1000.0f;
        descent = descent / scale * this.gs.getFontSize();
        ascent = ascent / scale * this.gs.getFontSize();
        return new float[]{ascent, descent};
    }
}

