/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.filters;

import com.itextpdf.kernel.pdf.MemoryLimitsAwareFilter;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.filters.FlateDecodeFilter;
import com.itextpdf.kernel.pdf.filters.LZWDecoder;
import java.io.ByteArrayOutputStream;

public class LZWDecodeFilter
extends MemoryLimitsAwareFilter {
    @Override
    public byte[] decode(byte[] b, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) {
        ByteArrayOutputStream outputStream = this.enableMemoryLimitsAwareHandler(streamDictionary);
        b = LZWDecodeFilter.LZWDecode(b, outputStream);
        b = FlateDecodeFilter.decodePredictor(b, decodeParams);
        return b;
    }

    public static byte[] LZWDecode(byte[] in) {
        return LZWDecodeFilter.LZWDecode(in, new ByteArrayOutputStream());
    }

    private static byte[] LZWDecode(byte[] in, ByteArrayOutputStream out) {
        LZWDecoder lzw = new LZWDecoder();
        lzw.decode(in, out);
        return out.toByteArray();
    }
}

