/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfNameTree
implements Serializable {
    private static final int NODE_SIZE = 40;
    private static final long serialVersionUID = 8153711383828989907L;
    private PdfCatalog catalog;
    private Map<String, PdfObject> items = new HashMap<String, PdfObject>();
    private PdfName treeType;
    private boolean modified;

    public PdfNameTree(PdfCatalog catalog, PdfName treeType) {
        this.treeType = treeType;
        this.catalog = catalog;
        this.items = this.getNames();
    }

    public Map<String, PdfObject> getNames() {
        PdfDictionary destinations;
        if (this.items.size() > 0) {
            return this.items;
        }
        PdfDictionary dictionary = ((PdfDictionary)this.catalog.getPdfObject()).getAsDictionary(PdfName.Names);
        if (dictionary != null && (dictionary = dictionary.getAsDictionary(this.treeType)) != null) {
            this.items = this.readTree(dictionary);
            HashSet<String> keys = new HashSet<String>();
            keys.addAll(this.items.keySet());
            for (String key : keys) {
                if (this.treeType.equals(PdfName.Dests)) {
                    PdfArray arr = this.getDestArray(this.items.get(key));
                    if (arr != null) {
                        this.items.put(key, arr);
                        continue;
                    }
                    this.items.remove(key);
                    continue;
                }
                if (this.items.get(key) != null) continue;
                this.items.remove(key);
            }
        }
        if (this.treeType.equals(PdfName.Dests) && (destinations = ((PdfDictionary)this.catalog.getPdfObject()).getAsDictionary(PdfName.Dests)) != null) {
            Set<PdfName> keys = destinations.keySet();
            for (PdfName key : keys) {
                PdfArray array = this.getDestArray(destinations.get(key));
                if (array == null) continue;
                this.items.put(key.getValue(), array);
            }
        }
        return this.items;
    }

    public void addEntry(String key, PdfObject value) {
        PdfObject existingVal = this.items.get(key);
        if (existingVal != null) {
            if (value.getIndirectReference() != null && value.getIndirectReference().equals(existingVal.getIndirectReference())) {
                return;
            }
            Logger logger = LoggerFactory.getLogger(PdfNameTree.class);
            logger.warn(MessageFormatUtil.format((String)"Name \"{0}\" already exists in the name tree; old value will be replaced by the new one.", (Object[])new Object[]{key}));
        }
        this.modified = true;
        this.items.put(key, value);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
    }

    public PdfDictionary buildTree() {
        Object[] names = new String[this.items.size()];
        names = this.items.keySet().toArray(names);
        Arrays.sort(names);
        if (names.length <= 40) {
            PdfDictionary dic = new PdfDictionary();
            PdfArray ar = new PdfArray();
            for (Object name : names) {
                ar.add(new PdfString((String)name, null));
                ar.add(this.items.get(name));
            }
            dic.put(PdfName.Names, ar);
            return dic;
        }
        int skip = 40;
        PdfDictionary[] kids = new PdfDictionary[(names.length + 40 - 1) / 40];
        for (int k = 0; k < kids.length; ++k) {
            int offset;
            int end = Math.min(offset + 40, names.length);
            PdfDictionary dic = new PdfDictionary();
            PdfArray arr = new PdfArray();
            arr.add(new PdfString((String)names[offset], null));
            arr.add(new PdfString((String)names[end - 1], null));
            dic.put(PdfName.Limits, arr);
            arr = new PdfArray();
            for (offset = k * 40; offset < end; ++offset) {
                arr.add(new PdfString((String)names[offset], null));
                arr.add(this.items.get(names[offset]));
            }
            dic.put(PdfName.Names, arr);
            dic.makeIndirect(this.catalog.getDocument());
            kids[k] = dic;
        }
        int top = kids.length;
        while (true) {
            int i;
            if (top <= 40) {
                PdfArray arr = new PdfArray();
                for (i = 0; i < top; ++i) {
                    arr.add(kids[i]);
                }
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.Kids, arr);
                return dic;
            }
            int tt = (names.length + (skip *= 40) - 1) / skip;
            for (i = 0; i < tt; ++i) {
                int offset;
                int end = Math.min(offset + 40, top);
                PdfDictionary dic = (PdfDictionary)new PdfDictionary().makeIndirect(this.catalog.getDocument());
                PdfArray arr = new PdfArray();
                arr.add(new PdfString((String)names[i * skip], null));
                arr.add(new PdfString((String)names[Math.min((i + 1) * skip, names.length) - 1], null));
                dic.put(PdfName.Limits, arr);
                arr = new PdfArray();
                for (offset = i * 40; offset < end; ++offset) {
                    arr.add(kids[offset]);
                }
                dic.put(PdfName.Kids, arr);
                kids[i] = dic;
            }
            top = tt;
        }
    }

    private Map<String, PdfObject> readTree(PdfDictionary dictionary) {
        HashMap<String, PdfObject> items = new HashMap<String, PdfObject>();
        if (dictionary != null) {
            this.iterateItems(dictionary, items, null);
        }
        return items;
    }

    private PdfString iterateItems(PdfDictionary dictionary, Map<String, PdfObject> items, PdfString leftOver) {
        block6: {
            PdfArray names;
            block5: {
                names = dictionary.getAsArray(PdfName.Names);
                if (names == null) break block5;
                for (int k = 0; k < names.size(); ++k) {
                    PdfString name;
                    if (leftOver == null) {
                        name = names.getAsString(k++);
                    } else {
                        name = leftOver;
                        leftOver = null;
                    }
                    if (k >= names.size()) {
                        return name;
                    }
                    items.put(name.toUnicodeString(), names.get(k));
                }
                break block6;
            }
            names = dictionary.getAsArray(PdfName.Kids);
            if (names == null) break block6;
            for (int k = 0; k < names.size(); ++k) {
                PdfDictionary kid = names.getAsDictionary(k);
                leftOver = this.iterateItems(kid, items, leftOver);
            }
        }
        return null;
    }

    private PdfArray getDestArray(PdfObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj.isArray()) {
            return (PdfArray)obj;
        }
        if (obj.isDictionary()) {
            PdfArray arr = ((PdfDictionary)obj).getAsArray(PdfName.D);
            return arr;
        }
        return null;
    }
}

