/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.crypto.securityhandler;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1InputStream;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Primitive;
import com.itextpdf.commons.bouncycastle.asn1.x509.IAlgorithmIdentifier;
import com.itextpdf.commons.bouncycastle.cert.IX509CertificateHolder;
import com.itextpdf.commons.bouncycastle.cms.ICMSEnvelopedData;
import com.itextpdf.commons.bouncycastle.cms.IRecipientInformation;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfEncryptor;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.security.IExternalDecryptionProcess;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

final class EncryptionUtils {
    private static final String ENVELOPE_ENCRYPTION_ALGORITHM_OID = "2.16.840.1.101.3.4.1.42";
    private static final String ENVELOPE_ENCRYPTION_ALGORITHM_JCA_NAME = "AES/CBC/PKCS5Padding";
    private static final int ENVELOPE_ENCRYPTION_KEY_LENGTH = 256;
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final Set<String> UNSUPPORTED_ALGORITHMS = new HashSet<String>();

    EncryptionUtils() {
    }

    static byte[] generateSeed(int seedLength) {
        byte[] seedBytes;
        try {
            KeyGenerator key = KeyGenerator.getInstance("AES");
            key.init(192, new SecureRandom());
            SecretKey sk = key.generateKey();
            seedBytes = new byte[seedLength];
            System.arraycopy(sk.getEncoded(), 0, seedBytes, 0, seedLength);
        }
        catch (NoSuchAlgorithmException e) {
            seedBytes = SecureRandom.getSeed(seedLength);
        }
        return seedBytes;
    }

    static byte[] fetchEnvelopedData(Key certificateKey, Certificate certificate, String certificateKeyProvider, IExternalDecryptionProcess externalDecryptionProcess, PdfArray recipients) {
        IX509CertificateHolder certHolder;
        boolean foundRecipient = false;
        byte[] envelopedData = null;
        try {
            certHolder = BOUNCY_CASTLE_FACTORY.createX509CertificateHolder(certificate.getEncoded());
        }
        catch (Exception f) {
            throw new PdfException("Exception occurred with PDF document decryption. One of the possible reasons is wrong password or wrong public key certificate and private key.", f);
        }
        if (externalDecryptionProcess == null) {
            for (int i = 0; i < recipients.size(); ++i) {
                PdfString recipient = recipients.getAsString(i);
                try {
                    ICMSEnvelopedData data = BOUNCY_CASTLE_FACTORY.createCMSEnvelopedData(recipient.getValueBytes());
                    for (IRecipientInformation recipientInfo : data.getRecipientInfos().getRecipients()) {
                        if (!recipientInfo.getRID().match(certHolder) || foundRecipient) continue;
                        envelopedData = PdfEncryptor.getContent(recipientInfo, (PrivateKey)certificateKey, certificateKeyProvider);
                        foundRecipient = true;
                    }
                    continue;
                }
                catch (Exception f) {
                    BouncyCastleFactoryCreator.getFactory().isEncryptionFeatureSupported(0, true);
                    throw new PdfException("Exception occurred with PDF document decryption. One of the possible reasons is wrong password or wrong public key certificate and private key.", f);
                }
            }
        } else {
            for (int i = 0; i < recipients.size(); ++i) {
                PdfString recipient = recipients.getAsString(i);
                try {
                    ICMSEnvelopedData data = BOUNCY_CASTLE_FACTORY.createCMSEnvelopedData(recipient.getValueBytes());
                    IRecipientInformation recipientInfo = data.getRecipientInfos().get(externalDecryptionProcess.getCmsRecipientId());
                    if (recipientInfo == null) continue;
                    envelopedData = recipientInfo.getContent(externalDecryptionProcess.getCmsRecipient());
                    foundRecipient = true;
                    continue;
                }
                catch (Exception f) {
                    throw new PdfException("Exception occurred with PDF document decryption. One of the possible reasons is wrong password or wrong public key certificate and private key.", f);
                }
            }
        }
        if (!foundRecipient || envelopedData == null) {
            throw new PdfException("Bad public key certificate and/or private key.");
        }
        return envelopedData;
    }

    static byte[] cipherBytes(X509Certificate x509certificate, byte[] abyte0, IAlgorithmIdentifier algorithmIdentifier) throws GeneralSecurityException {
        String algorithm = algorithmIdentifier.getAlgorithm().getId();
        if (UNSUPPORTED_ALGORITHMS.contains(algorithm)) {
            throw new PdfException(MessageFormatUtil.format((String)"Algorithm {0} is not supported.", (Object[])new Object[]{algorithm}));
        }
        return BOUNCY_CASTLE_FACTORY.createCipherBytes(x509certificate, abyte0, algorithmIdentifier);
    }

    static DERForRecipientParams calculateDERForRecipientParams(byte[] in) throws IOException, GeneralSecurityException {
        IASN1Primitive derobject;
        DERForRecipientParams parameters = new DERForRecipientParams();
        AlgorithmParameterGenerator algorithmparametergenerator = AlgorithmParameterGenerator.getInstance(ENVELOPE_ENCRYPTION_ALGORITHM_OID);
        AlgorithmParameters algorithmparameters = algorithmparametergenerator.generateParameters();
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(algorithmparameters.getEncoded("ASN.1"));
        try (IASN1InputStream asn1inputstream = BOUNCY_CASTLE_FACTORY.createASN1InputStream((InputStream)bytearrayinputstream);){
            derobject = asn1inputstream.readObject();
        }
        KeyGenerator keygenerator = "BC".equals(BOUNCY_CASTLE_FACTORY.getProviderName()) ? KeyGenerator.getInstance(ENVELOPE_ENCRYPTION_ALGORITHM_OID) : KeyGenerator.getInstance(ENVELOPE_ENCRYPTION_ALGORITHM_OID, BOUNCY_CASTLE_FACTORY.getProvider());
        keygenerator.init(256, BOUNCY_CASTLE_FACTORY.getSecureRandom());
        SecretKey secretkey = keygenerator.generateKey();
        Cipher cipher = "BC".equals(BOUNCY_CASTLE_FACTORY.getProviderName()) ? Cipher.getInstance(ENVELOPE_ENCRYPTION_ALGORITHM_JCA_NAME) : Cipher.getInstance(ENVELOPE_ENCRYPTION_ALGORITHM_JCA_NAME, BOUNCY_CASTLE_FACTORY.getProvider());
        cipher.init(1, (Key)secretkey, algorithmparameters);
        parameters.abyte0 = secretkey.getEncoded();
        parameters.abyte1 = cipher.doFinal(in);
        parameters.algorithmIdentifier = BOUNCY_CASTLE_FACTORY.createAlgorithmIdentifier(BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier(ENVELOPE_ENCRYPTION_ALGORITHM_OID), (IASN1Encodable)derobject);
        return parameters;
    }

    static {
        UNSUPPORTED_ALGORITHMS.add("1.2.840.10045.2.1");
    }

    static class DERForRecipientParams {
        byte[] abyte0;
        byte[] abyte1;
        IAlgorithmIdentifier algorithmIdentifier;

        DERForRecipientParams() {
        }
    }
}

