/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.AdobeGlyphList;
import com.itextpdf.io.font.FontEncoding;
import com.itextpdf.io.font.FontMetrics;
import com.itextpdf.io.font.FontNames;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.constants.FontDescriptorFlags;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.font.DocFontEncoding;
import com.itextpdf.kernel.font.PdfSimpleFont;
import com.itextpdf.kernel.font.Type3Font;
import com.itextpdf.kernel.font.Type3Glyph;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfType3Font
extends PdfSimpleFont<Type3Font> {
    private static final int FONT_BBOX_LLX = 0;
    private static final int FONT_BBOX_LLY = 1;
    private static final int FONT_BBOX_URX = 2;
    private static final int FONT_BBOX_URY = 3;
    private static final double[] DEFAULT_FONT_MATRIX = new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0};
    private double[] fontMatrix = DEFAULT_FONT_MATRIX;
    private double glyphSpaceNormalizationFactor;

    private double[] getFontMatrix() {
        return this.fontMatrix;
    }

    PdfType3Font(PdfDocument document, boolean colorized) {
        this.makeIndirect(document);
        this.subset = true;
        this.embedded = true;
        this.fontProgram = new Type3Font(colorized);
        this.fontEncoding = FontEncoding.createEmptyFontEncoding();
        this.setGlyphSpaceNormalizationFactor(1.0);
    }

    PdfType3Font(PdfDocument document, String fontName, String fontFamily, boolean colorized) {
        this(document, colorized);
        ((Type3Font)this.fontProgram).setFontName(fontName);
        ((Type3Font)this.fontProgram).setFontFamily(fontFamily);
        this.setGlyphSpaceNormalizationFactor(1.0);
    }

    PdfType3Font(PdfDictionary fontDictionary) {
        super(fontDictionary);
        PdfArray differences;
        this.subset = true;
        this.embedded = true;
        this.fontProgram = new Type3Font(false);
        this.fontEncoding = DocFontEncoding.createDocFontEncoding(fontDictionary.get(PdfName.Encoding), this.toUnicode);
        double[] fontMatrixArray = this.readFontMatrix();
        double[] fontBBoxRect = this.readFontBBox();
        double[] widthsArray = this.readWidths(fontDictionary);
        this.setGlyphSpaceNormalizationFactor(FontProgram.convertGlyphSpaceToTextSpace((double)fontMatrixArray[0]));
        PdfDictionary charProcsDic = fontDictionary.getAsDictionary(PdfName.CharProcs);
        PdfDictionary encoding = fontDictionary.getAsDictionary(PdfName.Encoding);
        PdfArray pdfArray = differences = encoding != null ? encoding.getAsArray(PdfName.Differences) : null;
        if (charProcsDic == null || differences == null) {
            LoggerFactory.getLogger(this.getClass()).warn("Type 3 font issue. Font cannot be initialized correctly.");
        }
        this.fillFontDescriptor(fontDictionary.getAsDictionary(PdfName.FontDescriptor));
        this.normalize1000UnitsToGlyphSpaceUnits(fontMatrixArray);
        this.normalizeGlyphSpaceUnitsTo1000Units(fontBBoxRect);
        this.normalizeGlyphSpaceUnitsTo1000Units(widthsArray);
        int firstChar = this.initializeUsedGlyphs(fontDictionary);
        this.fontMatrix = fontMatrixArray;
        this.initializeFontBBox(fontBBoxRect);
        this.initializeTypoAscenderDescender(fontBBoxRect);
        int[] widths = new int[256];
        for (int i = 0; i < widthsArray.length && firstChar + i < 256; ++i) {
            widths[firstChar + i] = (int)widthsArray[i];
        }
        this.addGlyphsFromDifferences(differences, charProcsDic, widths);
        this.addGlyphsFromCharProcs(charProcsDic, widths);
    }

    public void setFontName(String fontName) {
        ((Type3Font)this.fontProgram).setFontName(fontName);
    }

    public void setFontFamily(String fontFamily) {
        ((Type3Font)this.fontProgram).setFontFamily(fontFamily);
    }

    public void setFontWeight(int fontWeight) {
        ((Type3Font)this.fontProgram).setFontWeight(fontWeight);
    }

    public void setCapHeight(int capHeight) {
        ((Type3Font)this.fontProgram).setCapHeight(capHeight);
    }

    public void setItalicAngle(int italicAngle) {
        ((Type3Font)this.fontProgram).setItalicAngle(italicAngle);
    }

    public void setFontStretch(String fontWidth) {
        ((Type3Font)this.fontProgram).setFontStretch(fontWidth);
    }

    public void setPdfFontFlags(int flags) {
        ((Type3Font)this.fontProgram).setPdfFontFlags(flags);
    }

    public Type3Glyph getType3Glyph(int unicode) {
        return ((Type3Font)this.getFontProgram()).getType3Glyph(unicode);
    }

    @Override
    public boolean isSubset() {
        return true;
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    public int getNumberOfGlyphs() {
        return ((Type3Font)this.getFontProgram()).getNumberOfGlyphs();
    }

    public Type3Glyph addGlyph(char c, int wx, int llx, int lly, int urx, int ury) {
        Type3Glyph glyph = this.getType3Glyph(c);
        if (glyph != null) {
            return glyph;
        }
        int code = this.getFirstEmptyCode();
        glyph = new Type3Glyph(this.getDocument(), wx, llx, lly, urx, ury, ((Type3Font)this.getFontProgram()).isColorized());
        ((Type3Font)this.getFontProgram()).addGlyph(code, c, wx, new int[]{llx, lly, urx, ury}, glyph);
        this.fontEncoding.addSymbol(code, (int)c);
        if (!((Type3Font)this.getFontProgram()).isColorized()) {
            if (this.fontProgram.countOfGlyphs() == 0) {
                this.fontProgram.getFontMetrics().setBbox(llx, lly, urx, ury);
            } else {
                int[] bbox = this.fontProgram.getFontMetrics().getBbox();
                int newLlx = Math.min(bbox[0], llx);
                int newLly = Math.min(bbox[1], lly);
                int newUrx = Math.max(bbox[2], urx);
                int newUry = Math.max(bbox[3], ury);
                this.fontProgram.getFontMetrics().setBbox(newLlx, newLly, newUrx, newUry);
            }
        }
        return glyph;
    }

    @Override
    public Glyph getGlyph(int unicode) {
        if (this.fontEncoding.canEncode(unicode) || unicode < 33) {
            Glyph glyph = this.getFontProgram().getGlyph(this.fontEncoding.getUnicodeDifference(unicode));
            if (glyph == null && (glyph = (Glyph)this.notdefGlyphs.get(unicode)) == null) {
                glyph = new Glyph(-1, 0, unicode);
                this.notdefGlyphs.put(unicode, glyph);
            }
            return glyph;
        }
        return null;
    }

    @Override
    public boolean containsGlyph(int unicode) {
        return (this.fontEncoding.canEncode(unicode) || unicode < 33) && this.getFontProgram().getGlyph(this.fontEncoding.getUnicodeDifference(unicode)) != null;
    }

    @Override
    public void flush() {
        if (this.isFlushed()) {
            return;
        }
        this.ensureUnderlyingObjectHasIndirectReference();
        this.flushFontData();
        super.flush();
    }

    @Override
    protected PdfDictionary getFontDescriptor(String fontName) {
        if (fontName != null && fontName.length() > 0) {
            PdfDictionary fontDescriptor = new PdfDictionary();
            this.makeObjectIndirect(fontDescriptor);
            fontDescriptor.put(PdfName.Type, PdfName.FontDescriptor);
            FontMetrics fontMetrics = this.fontProgram.getFontMetrics();
            int capHeight = fontMetrics.getCapHeight();
            fontDescriptor.put(PdfName.CapHeight, new PdfNumber(this.normalize1000UnitsToGlyphSpaceUnits(capHeight)));
            fontDescriptor.put(PdfName.ItalicAngle, new PdfNumber(fontMetrics.getItalicAngle()));
            FontNames fontNames = this.fontProgram.getFontNames();
            fontDescriptor.put(PdfName.FontWeight, new PdfNumber(fontNames.getFontWeight()));
            fontDescriptor.put(PdfName.FontName, new PdfName(fontName));
            if (fontNames.getFamilyName() != null && fontNames.getFamilyName().length > 0 && fontNames.getFamilyName()[0].length >= 4) {
                fontDescriptor.put(PdfName.FontFamily, new PdfString(fontNames.getFamilyName()[0][3]));
            }
            int flags = this.fontProgram.getPdfFontFlags();
            flags &= ~(FontDescriptorFlags.Symbolic | FontDescriptorFlags.Nonsymbolic);
            fontDescriptor.put(PdfName.Flags, new PdfNumber(flags |= this.fontEncoding.isFontSpecific() ? FontDescriptorFlags.Symbolic : FontDescriptorFlags.Nonsymbolic));
            return fontDescriptor;
        }
        if (((PdfDictionary)this.getPdfObject()).getIndirectReference() != null && ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument().isTagged()) {
            Logger logger = LoggerFactory.getLogger(PdfType3Font.class);
            logger.warn("Type 3 font issue. Font Descriptor is required for tagged PDF. FontName shall be specified.");
        }
        return null;
    }

    @Override
    protected PdfArray buildWidthsArray(int firstChar, int lastChar) {
        double[] widths = new double[lastChar - firstChar + 1];
        for (int k = firstChar; k <= lastChar; ++k) {
            int i = k - firstChar;
            if (this.usedGlyphs[k] == 0) {
                widths[i] = 0.0;
                continue;
            }
            int uni = this.getFontEncoding().getUnicode(k);
            Glyph glyph = uni > -1 ? this.getGlyph(uni) : this.getFontProgram().getGlyphByCode(k);
            widths[i] = glyph != null ? (double)glyph.getWidth() : 0.0;
        }
        this.normalize1000UnitsToGlyphSpaceUnits(widths);
        return new PdfArray(widths);
    }

    @Override
    protected void addFontStream(PdfDictionary fontDescriptor) {
    }

    protected PdfDocument getDocument() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
    }

    final double getGlyphSpaceNormalizationFactor() {
        return this.glyphSpaceNormalizationFactor;
    }

    final void setGlyphSpaceNormalizationFactor(double glyphSpaceNormalizationFactor) {
        this.glyphSpaceNormalizationFactor = glyphSpaceNormalizationFactor;
    }

    private void addGlyphsFromDifferences(PdfArray differences, PdfDictionary charProcsDic, int[] widths) {
        if (differences == null || charProcsDic == null) {
            return;
        }
        int currentNumber = 0;
        for (int k = 0; k < differences.size(); ++k) {
            PdfObject obj = differences.get(k);
            if (obj.isNumber()) {
                currentNumber = ((PdfNumber)obj).intValue();
                continue;
            }
            if (currentNumber > 255) continue;
            String glyphName = ((PdfName)obj).getValue();
            int unicode = this.fontEncoding.getUnicode(currentNumber);
            if (this.getFontProgram().getGlyphByCode(currentNumber) == null && charProcsDic.containsKey(new PdfName(glyphName))) {
                this.fontEncoding.setDifference(currentNumber, glyphName);
                ((Type3Font)this.getFontProgram()).addGlyph(currentNumber, unicode, widths[currentNumber], null, new Type3Glyph(charProcsDic.getAsStream(new PdfName(glyphName)), this.getDocument()));
            }
            ++currentNumber;
        }
    }

    private int getFirstEmptyCode() {
        boolean startFrom = true;
        for (int i = 1; i <= 255; ++i) {
            if (this.fontEncoding.canDecode(i) || this.fontProgram.getGlyphByCode(i) != null) continue;
            return i;
        }
        return -1;
    }

    private void addGlyphsFromCharProcs(PdfDictionary charProcsDic, int[] widths) {
        if (charProcsDic == null) {
            return;
        }
        Map unicodeToCode = null;
        if (this.getToUnicode() != null) {
            try {
                unicodeToCode = this.getToUnicode().createReverseMapping();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (PdfName glyphName : charProcsDic.keySet()) {
            int unicode = AdobeGlyphList.nameToUnicode((String)glyphName.getValue());
            int code = -1;
            if (this.fontEncoding.canEncode(unicode)) {
                code = this.fontEncoding.convertToByte(unicode);
            } else if (unicodeToCode != null && unicodeToCode.containsKey(unicode)) {
                code = (Integer)unicodeToCode.get(unicode);
            }
            if (code == -1 || this.getFontProgram().getGlyphByCode(code) != null) continue;
            ((Type3Font)this.getFontProgram()).addGlyph(code, unicode, widths[code], null, new Type3Glyph(charProcsDic.getAsStream(glyphName), this.getDocument()));
        }
    }

    private void flushFontData() {
        if (((Type3Font)this.getFontProgram()).getNumberOfGlyphs() < 1) {
            throw new PdfException("No glyphs defined for type3 font.");
        }
        PdfDictionary charProcs = new PdfDictionary();
        for (int i = 0; i <= 255; ++i) {
            Type3Glyph glyph = null;
            if (this.fontEncoding.canDecode(i)) {
                glyph = this.getType3Glyph(this.fontEncoding.getUnicode(i));
            }
            if (glyph == null) {
                glyph = ((Type3Font)this.getFontProgram()).getType3GlyphByCode(i);
            }
            if (glyph == null) continue;
            charProcs.put(new PdfName(this.fontEncoding.getDifference(i)), glyph.getContentStream());
            glyph.getContentStream().flush();
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.CharProcs, charProcs);
        double[] fontMatrixDouble = this.getFontMatrix();
        int[] fontBBoxInt = this.getFontProgram().getFontMetrics().getBbox();
        double[] fontBBoxDouble = new double[]{fontBBoxInt[0], fontBBoxInt[1], fontBBoxInt[2], fontBBoxInt[3]};
        this.normalizeGlyphSpaceUnitsTo1000Units(fontMatrixDouble);
        this.normalize1000UnitsToGlyphSpaceUnits(fontBBoxDouble);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.FontMatrix, new PdfArray(fontMatrixDouble));
        ((PdfDictionary)this.getPdfObject()).put(PdfName.FontBBox, new PdfArray(fontBBoxDouble));
        String fontName = this.fontProgram.getFontNames().getFontName();
        super.flushFontData(fontName, PdfName.Type3);
        this.makeObjectIndirect(((PdfDictionary)this.getPdfObject()).get(PdfName.Widths));
        ((PdfDictionary)this.getPdfObject()).remove(PdfName.BaseFont);
    }

    private double[] readWidths(PdfDictionary fontDictionary) {
        PdfArray pdfWidths = fontDictionary.getAsArray(PdfName.Widths);
        if (pdfWidths == null) {
            throw new PdfException("Missing required field {0} in font dictionary.").setMessageParams(PdfName.Widths);
        }
        double[] widths = new double[pdfWidths.size()];
        for (int i = 0; i < pdfWidths.size(); ++i) {
            PdfNumber n = pdfWidths.getAsNumber(i);
            widths[i] = n != null ? n.doubleValue() : 0.0;
        }
        return widths;
    }

    private int initializeUsedGlyphs(PdfDictionary fontDictionary) {
        int firstChar = this.normalizeFirstLastChar(fontDictionary.getAsNumber(PdfName.FirstChar), 0);
        int lastChar = this.normalizeFirstLastChar(fontDictionary.getAsNumber(PdfName.LastChar), 255);
        for (int i = firstChar; i <= lastChar; ++i) {
            this.usedGlyphs[i] = 1;
        }
        return firstChar;
    }

    private double[] readFontBBox() {
        PdfArray fontBBox = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.FontBBox);
        if (fontBBox != null) {
            double llx = fontBBox.getAsNumber(0).doubleValue();
            double lly = fontBBox.getAsNumber(1).doubleValue();
            double urx = fontBBox.getAsNumber(2).doubleValue();
            double ury = fontBBox.getAsNumber(3).doubleValue();
            return new double[]{llx, lly, urx, ury};
        }
        return new double[]{0.0, 0.0, 0.0, 0.0};
    }

    private double[] readFontMatrix() {
        PdfArray fontMatrixArray = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.FontMatrix);
        if (fontMatrixArray == null) {
            throw new PdfException("Missing required field {0} in font dictionary.").setMessageParams(PdfName.FontMatrix);
        }
        double[] fontMatrix = new double[6];
        for (int i = 0; i < fontMatrixArray.size(); ++i) {
            fontMatrix[i] = ((PdfNumber)fontMatrixArray.get(i)).getValue();
        }
        return fontMatrix;
    }

    private void initializeTypoAscenderDescender(double[] fontBBoxRect) {
        ((Type3Font)this.fontProgram).setTypoAscender((int)fontBBoxRect[3]);
        ((Type3Font)this.fontProgram).setTypoDescender((int)fontBBoxRect[1]);
    }

    private void initializeFontBBox(double[] fontBBoxRect) {
        this.fontProgram.getFontMetrics().setBbox((int)fontBBoxRect[0], (int)fontBBoxRect[1], (int)fontBBoxRect[2], (int)fontBBoxRect[3]);
    }

    private void normalizeGlyphSpaceUnitsTo1000Units(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.normalizeGlyphSpaceUnitsTo1000Units(array[i]);
        }
    }

    private double normalizeGlyphSpaceUnitsTo1000Units(double value) {
        return value * this.getGlyphSpaceNormalizationFactor();
    }

    private void normalize1000UnitsToGlyphSpaceUnits(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.normalize1000UnitsToGlyphSpaceUnits(array[i]);
        }
    }

    private double normalize1000UnitsToGlyphSpaceUnits(double value) {
        return value / this.getGlyphSpaceNormalizationFactor();
    }

    private void fillFontDescriptor(PdfDictionary fontDesc) {
        PdfString fontFamily;
        PdfName fontName;
        PdfName fontStretch;
        if (fontDesc == null) {
            return;
        }
        PdfNumber v = fontDesc.getAsNumber(PdfName.CapHeight);
        if (v != null) {
            double capHeight = v.doubleValue();
            this.setCapHeight((int)this.normalizeGlyphSpaceUnitsTo1000Units(capHeight));
        }
        if ((v = fontDesc.getAsNumber(PdfName.ItalicAngle)) != null) {
            this.setItalicAngle(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.FontWeight)) != null) {
            this.setFontWeight(v.intValue());
        }
        if ((fontStretch = fontDesc.getAsName(PdfName.FontStretch)) != null) {
            this.setFontStretch(fontStretch.getValue());
        }
        if ((fontName = fontDesc.getAsName(PdfName.FontName)) != null) {
            this.setFontName(fontName.getValue());
        }
        if ((fontFamily = fontDesc.getAsString(PdfName.FontFamily)) != null) {
            this.setFontFamily(fontFamily.getValue());
        }
    }

    private int normalizeFirstLastChar(PdfNumber firstLast, int defaultValue) {
        if (firstLast == null) {
            return defaultValue;
        }
        int result = firstLast.intValue();
        return result < 0 || result > 255 ? defaultValue : result;
    }
}

