/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.VersionConforming;
import com.itextpdf.kernel.pdf.filespec.PdfFileSpec;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.ParentTreeHandler;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructIdTree;
import com.itextpdf.kernel.pdf.tagging.StructureTreeCopier;
import com.itextpdf.kernel.pdf.tagutils.TagTreeIterator;
import com.itextpdf.kernel.pdf.tagutils.TagTreeIteratorFlusher;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfStructTreeRoot
extends PdfObjectWrapper<PdfDictionary>
implements IStructureNode {
    private PdfDocument document;
    private ParentTreeHandler parentTreeHandler;
    private PdfStructIdTree idTree = null;
    private static Map<String, PdfName> staticRoleNames = new ConcurrentHashMap<String, PdfName>();

    public PdfStructTreeRoot(PdfDocument document) {
        this((PdfDictionary)new PdfDictionary().makeIndirect(document), document);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.StructTreeRoot);
    }

    public PdfStructTreeRoot(PdfDictionary structTreeRootDict, PdfDocument document) {
        super(structTreeRootDict);
        this.document = document;
        if (this.document == null) {
            PdfStructTreeRoot.ensureObjectIsAddedToDocument(structTreeRootDict);
            this.document = structTreeRootDict.getIndirectReference().getDocument();
        }
        this.setForbidRelease();
        this.parentTreeHandler = new ParentTreeHandler(this);
        this.getRoleMap();
    }

    public static PdfName convertRoleToPdfName(String role) {
        PdfName name = PdfName.staticNames.get(role);
        if (name != null) {
            return name;
        }
        name = staticRoleNames.get(role);
        if (name != null) {
            return name;
        }
        name = new PdfName(role);
        staticRoleNames.put(role, name);
        return name;
    }

    public PdfStructElem addKid(PdfStructElem structElem) {
        return this.addKid(-1, structElem);
    }

    public PdfStructElem addKid(int index, PdfStructElem structElem) {
        this.addKidObject(index, (PdfDictionary)structElem.getPdfObject());
        return structElem;
    }

    @Override
    public IStructureNode getParent() {
        return null;
    }

    @Override
    public List<IStructureNode> getKids() {
        PdfObject k = ((PdfDictionary)this.getPdfObject()).get(PdfName.K);
        ArrayList<IStructureNode> kids = new ArrayList<IStructureNode>();
        if (k != null) {
            if (k.isArray()) {
                PdfArray a = (PdfArray)k;
                for (int i = 0; i < a.size(); ++i) {
                    this.ifKidIsStructElementAddToList(a.get(i), kids);
                }
            } else {
                this.ifKidIsStructElementAddToList(k, kids);
            }
        }
        return kids;
    }

    public PdfArray getKidsObject() {
        PdfArray k = null;
        PdfObject kObj = ((PdfDictionary)this.getPdfObject()).get(PdfName.K);
        if (kObj != null && kObj.isArray()) {
            k = (PdfArray)kObj;
        }
        if (k == null) {
            k = new PdfArray();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.K, k);
            this.setModified();
            if (kObj != null) {
                k.add(kObj);
            }
        }
        return k;
    }

    public void addRoleMapping(String fromRole, String toRole) {
        PdfDictionary roleMap = this.getRoleMap();
        PdfObject prevVal = roleMap.put(PdfStructTreeRoot.convertRoleToPdfName(fromRole), PdfStructTreeRoot.convertRoleToPdfName(toRole));
        if (prevVal != null && prevVal instanceof PdfName) {
            Logger logger = LoggerFactory.getLogger(PdfStructTreeRoot.class);
            logger.warn(MessageFormat.format("Existing mapping for {0} in structure tree root role map was {1} and it was overwritten with {2}.", fromRole, prevVal, toRole));
        }
        if (roleMap.isIndirect()) {
            roleMap.setModified();
        } else {
            this.setModified();
        }
    }

    public PdfDictionary getRoleMap() {
        PdfDictionary roleMap = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.RoleMap);
        if (roleMap == null) {
            roleMap = new PdfDictionary();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.RoleMap, roleMap);
            this.setModified();
        }
        return roleMap;
    }

    public List<PdfNamespace> getNamespaces() {
        PdfArray namespacesArray = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Namespaces);
        if (namespacesArray == null) {
            return Collections.emptyList();
        }
        ArrayList<PdfNamespace> namespacesList = new ArrayList<PdfNamespace>(namespacesArray.size());
        for (int i = 0; i < namespacesArray.size(); ++i) {
            namespacesList.add(new PdfNamespace(namespacesArray.getAsDictionary(i)));
        }
        return namespacesList;
    }

    public void addNamespace(PdfNamespace namespace) {
        this.getNamespacesObject().add((PdfObject)namespace.getPdfObject());
        this.setModified();
    }

    public PdfArray getNamespacesObject() {
        PdfArray namespacesArray = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Namespaces);
        if (namespacesArray == null) {
            namespacesArray = new PdfArray();
            VersionConforming.validatePdfVersionForDictEntry(this.getDocument(), PdfVersion.PDF_2_0, PdfName.Namespaces, PdfName.StructTreeRoot);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Namespaces, namespacesArray);
            this.setModified();
        }
        return namespacesArray;
    }

    public List<PdfFileSpec> getPronunciationLexiconsList() {
        PdfArray pronunciationLexicons = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.PronunciationLexicon);
        if (pronunciationLexicons == null) {
            return Collections.emptyList();
        }
        ArrayList<PdfFileSpec> lexiconsList = new ArrayList<PdfFileSpec>(pronunciationLexicons.size());
        for (int i = 0; i < pronunciationLexicons.size(); ++i) {
            lexiconsList.add(PdfFileSpec.wrapFileSpecObject(pronunciationLexicons.get(i)));
        }
        return lexiconsList;
    }

    public void addPronunciationLexicon(PdfFileSpec pronunciationLexiconFileSpec) {
        PdfArray pronunciationLexicons = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.PronunciationLexicon);
        if (pronunciationLexicons == null) {
            pronunciationLexicons = new PdfArray();
            VersionConforming.validatePdfVersionForDictEntry(this.getDocument(), PdfVersion.PDF_2_0, PdfName.PronunciationLexicon, PdfName.StructTreeRoot);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.PronunciationLexicon, pronunciationLexicons);
        }
        pronunciationLexicons.add((PdfObject)pronunciationLexiconFileSpec.getPdfObject());
        this.setModified();
    }

    public void createParentTreeEntryForPage(PdfPage page) {
        this.getParentTreeHandler().createParentTreeEntryForPage(page);
    }

    public void savePageStructParentIndexIfNeeded(PdfPage page) {
        this.getParentTreeHandler().savePageStructParentIndexIfNeeded(page);
    }

    public Collection<PdfMcr> getPageMarkedContentReferences(PdfPage page) {
        ParentTreeHandler.PageMcrsContainer pageMcrs = this.getParentTreeHandler().getPageMarkedContentReferences(page);
        return pageMcrs != null ? Collections.unmodifiableCollection(pageMcrs.getAllMcrsAsCollection()) : null;
    }

    public PdfMcr findMcrByMcid(PdfDictionary pageDict, int mcid) {
        return this.getParentTreeHandler().findMcrByMcid(pageDict, mcid);
    }

    public PdfObjRef findObjRefByStructParentIndex(PdfDictionary pageDict, int structParentIndex) {
        return this.getParentTreeHandler().findObjRefByStructParentIndex(pageDict, structParentIndex);
    }

    @Override
    public PdfName getRole() {
        return null;
    }

    @Override
    public void flush() {
        for (int i = 0; i < this.getDocument().getNumberOfPages(); ++i) {
            this.createParentTreeEntryForPage(this.getDocument().getPage(i + 1));
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.ParentTree, this.getParentTreeHandler().buildParentTree());
        ((PdfDictionary)this.getPdfObject()).put(PdfName.ParentTreeNextKey, new PdfNumber(this.getDocument().getNextStructParentIndex()));
        if (this.idTree != null && this.idTree.isModified()) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.IDTree, this.idTree.buildTree().makeIndirect(this.getDocument()));
        }
        if (!this.getDocument().isAppendMode()) {
            PdfStructTreeRoot.flushAllKids(this);
        }
        super.flush();
    }

    public void copyTo(PdfDocument destDocument, Map<PdfPage, PdfPage> page2page) {
        StructureTreeCopier.copyTo(destDocument, page2page, this.getDocument());
    }

    public void copyTo(PdfDocument destDocument, int insertBeforePage, Map<PdfPage, PdfPage> page2page) {
        StructureTreeCopier.copyTo(destDocument, insertBeforePage, page2page, this.getDocument());
    }

    public void move(PdfPage fromPage, int insertBeforePage) {
        for (int i = 1; i <= this.getDocument().getNumberOfPages(); ++i) {
            if (!this.getDocument().getPage(i).isFlushed()) continue;
            throw new PdfException(MessageFormatUtil.format((String)"Cannot move pages in partly flushed document. Page number {0} is already flushed.", (Object[])new Object[]{i}));
        }
        StructureTreeCopier.move(this.getDocument(), fromPage, insertBeforePage);
    }

    public int getParentTreeNextKey() {
        return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.ParentTreeNextKey).intValue();
    }

    public int getNextMcidForPage(PdfPage page) {
        return this.getParentTreeHandler().getNextMcidForPage(page);
    }

    public PdfDocument getDocument() {
        return this.document;
    }

    public void addAssociatedFile(String description, PdfFileSpec fs) {
        PdfArray afArray;
        if (null == ((PdfDictionary)fs.getPdfObject()).get(PdfName.AFRelationship)) {
            Logger logger = LoggerFactory.getLogger(PdfStructTreeRoot.class);
            logger.error("For associated files their associated file specification dictionaries shall include the AFRelationship key.");
        }
        if (null != description) {
            this.getDocument().getCatalog().getNameTree(PdfName.EmbeddedFiles).addEntry(description, (PdfObject)fs.getPdfObject());
        }
        if ((afArray = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.AF)) == null) {
            afArray = new PdfArray();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.AF, afArray);
        }
        afArray.add((PdfObject)fs.getPdfObject());
    }

    public void addAssociatedFile(PdfFileSpec fs) {
        this.addAssociatedFile(null, fs);
    }

    public PdfArray getAssociatedFiles(boolean create) {
        PdfArray afArray = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.AF);
        if (afArray == null && create) {
            afArray = new PdfArray();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.AF, afArray);
        }
        return afArray;
    }

    public PdfStructIdTree getIdTree() {
        if (this.idTree == null) {
            PdfDictionary idTreeDict = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.IDTree);
            this.idTree = idTreeDict == null ? new PdfStructIdTree(this.document) : PdfStructIdTree.readFromDictionary(this.document, idTreeDict);
        }
        return this.idTree;
    }

    ParentTreeHandler getParentTreeHandler() {
        return this.parentTreeHandler;
    }

    void addKidObject(int index, PdfDictionary structElem) {
        if (index == -1) {
            this.getKidsObject().add(structElem);
        } else {
            this.getKidsObject().add(index, structElem);
        }
        if (PdfStructElem.isStructElem(structElem)) {
            if (((PdfDictionary)this.getPdfObject()).getIndirectReference() == null) {
                throw new PdfException("Structure element dictionary shall be an indirect object in order to have children.");
            }
            structElem.put(PdfName.P, (PdfObject)this.getPdfObject());
        }
        this.setModified();
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    private static void flushAllKids(PdfStructTreeRoot elem) {
        TagTreeIterator iterator = new TagTreeIterator(elem, TagTreeIterator.TreeTraversalOrder.POST_ORDER);
        iterator.addHandler(new TagTreeIteratorFlusher());
        iterator.traverse();
    }

    private void ifKidIsStructElementAddToList(PdfObject kid, List<IStructureNode> kids) {
        if (kid.isFlushed()) {
            kids.add(null);
        } else if (kid.isDictionary() && PdfStructElem.isStructElem((PdfDictionary)kid)) {
            kids.add(new PdfStructElem((PdfDictionary)kid));
        }
    }
}

