/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base;

import com.itextpdf.commons.actions.data.CommonsProductData;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class CommonsVersionChecker {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([\\d]+)\\.([\\d]+)\\.([\\d]+).*$");
    private static final int MINIMAL_COMMONS_MAJOR_VERSION = 7;
    private static final int MINIMAL_COMMONS_MINOR_VERSION = 2;
    private static final int MINIMAL_COMMONS_PATCH_VERSION = 0;

    private CommonsVersionChecker() {
    }

    static void checkCommonsVersion() {
        String commonsVersion = CommonsProductData.getInstance().getVersion();
        CommonsVersionChecker.checkVersion(7, 2, 0, commonsVersion);
    }

    static void checkVersion(int expectedMajor, int expectedMinor, int expectedPatch, String actualVersion) {
        if (CommonsVersionChecker.isInvalidVersion(expectedMajor, expectedMinor, expectedPatch, actualVersion)) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)"Version \"{0}\" of commons module of iText does not match minimal expected version \"{1}.{2}.{3}\".", (Object[])new Object[]{actualVersion, expectedMajor, expectedMinor, expectedPatch}));
        }
    }

    static boolean isInvalidVersion(int expectedMajor, int expectedMinor, int expectedPatch, String actualVersion) {
        Matcher matcher = VERSION_PATTERN.matcher(actualVersion);
        if (!matcher.find()) {
            return true;
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Integer.parseInt(matcher.group(3));
        if (expectedMajor > major) {
            return true;
        }
        if (expectedMajor < major) {
            return false;
        }
        if (expectedMinor > minor) {
            return true;
        }
        if (expectedMinor < minor) {
            return false;
        }
        return expectedPatch > patch;
    }
}

