/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base;

import com.itextpdf.commons.actions.AbstractITextConfigurationEvent;
import com.itextpdf.commons.actions.processors.ITextProductEventProcessor;
import com.itextpdf.licensing.base.actions.LicenseITextProductEventProcessor;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class LicenseFileService
extends AbstractITextConfigurationEvent {
    private static final LicenseFileService INSTANCE = new LicenseFileService();
    private static final Object SYNC_LOCK = new Object();
    private static volatile String lastReturnedKey = null;

    private LicenseFileService() {
    }

    public static LicenseFile getLicenseFileForProduct(String productName) {
        ITextProductEventProcessor proc = INSTANCE.getActiveProcessor(productName);
        if (proc instanceof LicenseITextProductEventProcessor) {
            LicenseITextProductEventProcessor licenseProc = (LicenseITextProductEventProcessor)proc;
            return licenseProc.getLicenseFile();
        }
        return null;
    }

    public static List<LicenseFile> getLicenseFiles() {
        Map proc = INSTANCE.getProcessors();
        ArrayList<LicenseFile> licenseFileList = new ArrayList<LicenseFile>();
        for (ITextProductEventProcessor value : proc.values()) {
            if (!(value instanceof LicenseITextProductEventProcessor)) continue;
            licenseFileList.add(((LicenseITextProductEventProcessor)value).getLicenseFile());
        }
        return licenseFileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LicenseFile getSomeLoadedLicenseFileWithTryPreserveKey() {
        List<LicenseFile> licenseFiles = LicenseFileService.getLicenseFiles();
        if (licenseFiles.isEmpty()) {
            return null;
        }
        Object object = SYNC_LOCK;
        synchronized (object) {
            if (lastReturnedKey != null) {
                for (LicenseFile file : LicenseFileService.getLicenseFiles()) {
                    if (!lastReturnedKey.equals(file.getKey())) continue;
                    return file;
                }
            }
            LicenseFile toReturn = licenseFiles.get(0);
            lastReturnedKey = toReturn.getKey();
            return toReturn;
        }
    }

    protected void doAction() {
        throw new IllegalStateException("This is util event for internal usage.");
    }
}

