/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base;

import com.itextpdf.commons.actions.EventManager;
import com.itextpdf.commons.actions.IEvent;
import com.itextpdf.commons.actions.NamespaceConstant;
import com.itextpdf.licensing.base.UpdateContextManagerEvent;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.util.CollectionUtil;

final class ProductManager {
    private static final String PDF_CALLIGRAPH_NAMESPACE = "com.itextpdf.typography";
    private static final String PDF_RENDER_NAMESPACE = "com.itextpdf.pdfrender";
    private static final String PDF_OFFICE_NAMESPACE = "com.itextpdf.pdfoffice";
    private static final String PDF_OPTIMIZER_NAMESPACE = "com.itextpdf.pdfoptimizer";
    private static final String PDF_XFA_NAMESPACE = "com.itextpdf.tool.xml";
    private static final String DITO_NAMESPACE = "com.itextpdf.dito";
    private static final String PDF_2_DATA_NAMESPACE = "com.itextpdf.pdf2data";
    private static final String PDF_CALLIGRAPH_PRODUCT = "pdfCalligraph";
    private static final String PDF_RENDER_PRODUCT = "pdfRender";
    private static final String PDF_OFFICE_PRODUCT = "pdfOffice";
    private static final String PDF_XFA_PRODUCT = "pdfXfa";
    private static final String PDF_OPTIMIZER_PRODUCT = "pdfOptimizer";
    private static final String DITO_SDK_PRODUCT = "dito-sdk";
    private static final String PDF_2_DATA_PRODUCT = "pdf2Data";

    private ProductManager() {
    }

    static boolean isCoreOrCoreIndependentProduct(LicenseFile licenseFile) {
        if (licenseFile == null) {
            throw new LicenseKeyException("License file was corrupted.");
        }
        String product = licenseFile.getProduct();
        return "itext-core".equals(product) || DITO_SDK_PRODUCT.equals(product);
    }

    static void registerProductsContext() {
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(CollectionUtil.asList(DITO_NAMESPACE), CollectionUtil.asList(DITO_SDK_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(CollectionUtil.asList(PDF_2_DATA_NAMESPACE), CollectionUtil.asList(PDF_2_DATA_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(CollectionUtil.asList(PDF_CALLIGRAPH_NAMESPACE), CollectionUtil.asList(PDF_CALLIGRAPH_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(CollectionUtil.asList(PDF_RENDER_NAMESPACE), CollectionUtil.asList(PDF_RENDER_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(CollectionUtil.asList(PDF_XFA_NAMESPACE), CollectionUtil.asList(PDF_XFA_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(CollectionUtil.asList(PDF_OFFICE_NAMESPACE), CollectionUtil.asList(PDF_OFFICE_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(CollectionUtil.asList(PDF_OPTIMIZER_NAMESPACE), CollectionUtil.asList(PDF_OPTIMIZER_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(NamespaceConstant.ITEXT_CORE_NAMESPACES, CollectionUtil.asList("itext-core", PDF_CALLIGRAPH_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(CollectionUtil.asList("com.itextpdf.html2pdf"), CollectionUtil.asList("pdfHtml", PDF_CALLIGRAPH_PRODUCT)));
    }

    static void registerWhitelistedNamespaces() {
    }
}

