/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.actions;

import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.licensefile.OnExpirationStrategy;
import com.itextpdf.licensing.base.strategy.IStrategy;
import com.itextpdf.licensing.base.strategy.StrategyFactory;
import java.util.Date;

final class LicenseFileExpirationChecker {
    private final Date expireDate;
    private final IStrategy onExpireStrategy;

    LicenseFileExpirationChecker(String productName, OnExpirationStrategy onExpirationStrategy, String expireDate, String gracePeriod) {
        try {
            this.expireDate = DateTimeUtil.parseWithDefaultPattern((String)expireDate);
        }
        catch (Exception ex) {
            throw new IllegalStateException(MessageFormatUtil.format((String)"Invalid expire date for license file which corresponds to \"{0}\" product.", (Object[])new Object[]{productName}));
        }
        this.onExpireStrategy = StrategyFactory.createLicenseFileExpirationStrategy(productName, onExpirationStrategy, this.expireDate, gracePeriod);
    }

    void checkExpiration() {
        if (DateTimeUtil.isInPast((Date)DateTimeUtil.addDaysToDate((Date)this.expireDate, (int)1))) {
            this.onExpireStrategy.onFailure();
        } else {
            this.onExpireStrategy.onSuccess();
        }
        this.onExpireStrategy.onProcessing();
    }
}

