/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.actions;

import com.itextpdf.commons.actions.AbstractProductProcessITextEvent;
import com.itextpdf.commons.actions.EventManager;
import com.itextpdf.commons.actions.IEvent;
import com.itextpdf.commons.actions.confirmations.ConfirmEvent;
import com.itextpdf.commons.actions.processors.AbstractITextProductEventProcessor;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.actions.LicenseFileExpirationChecker;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.licensefile.ProductVersion;
import com.itextpdf.licensing.base.reporting.IReportingHandler;
import com.itextpdf.licensing.base.statistics.ProductVersionStatisticsEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LicenseITextProductEventProcessor
extends AbstractITextProductEventProcessor {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([\\d]+)\\.([\\d]+).*$");
    private final LicenseFile licenseFile;
    private final LicenseFileExpirationChecker licenseFileExpirationChecker;
    private final IReportingHandler reportingHandler;

    LicenseITextProductEventProcessor(LicenseFile licenseFile, IReportingHandler reportingHandler) {
        super(licenseFile.getProduct());
        this.licenseFile = licenseFile;
        this.licenseFileExpirationChecker = new LicenseFileExpirationChecker(licenseFile.getProduct(), licenseFile.getOnExpiration(), licenseFile.getExpirationDate(), licenseFile.getGracePeriod());
        this.reportingHandler = reportingHandler;
    }

    public String getUsageType() {
        return this.licenseFile.getLicenseType().name();
    }

    public String getProducer() {
        String producer = this.licenseFile.getProducerLine();
        if (producer == null || producer.isEmpty()) {
            return super.getProducer() + ", " + this.licenseFile.getLicensee().getCompany();
        }
        return producer;
    }

    public void onEvent(AbstractProductProcessITextEvent event) {
        if (this.licenseFile.getProduct().equals(event.getProductName())) {
            this.licenseFileExpirationChecker.checkExpiration();
            this.checkVersion(event.getProductData().getVersion());
            this.reportingHandler.checkEvent(event.getProductName(), event.getEventType());
            if (event instanceof ConfirmEvent) {
                this.reportingHandler.reportEvent((ConfirmEvent)event);
                EventManager.getInstance().onEvent((IEvent)new ProductVersionStatisticsEvent(event.getProductData()));
            }
        }
    }

    public LicenseFile getLicenseFile() {
        return this.licenseFile;
    }

    private void checkVersion(String versionStr) {
        int minor;
        int minorFromLicense;
        ProductVersion productVersion = this.licenseFile.getProductVersion();
        if (productVersion == null) {
            return;
        }
        Matcher matcher = VERSION_PATTERN.matcher(versionStr);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid event version.");
        }
        int major = Integer.parseInt(matcher.group(1));
        int majorFromLicence = productVersion.getMajor();
        if (majorFromLicence != major) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)"Major version \"{0}\" of product \"{1}\" doesn't match to supported version \"{2}\" from license file.", (Object[])new Object[]{major, this.licenseFile.getProduct(), majorFromLicence}));
        }
        if (productVersion.getMinor() != null && (minorFromLicense = productVersion.getMinor().intValue()) != (minor = Integer.parseInt(matcher.group(2)))) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)"Minor version \"{0}\" of product \"{1}\" doesn't match to supported version \"{2}\" from license file.", (Object[])new Object[]{minor, this.licenseFile.getProduct(), minorFromLicense}));
        }
    }
}

