/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting;

import com.itextpdf.commons.actions.AbstractProductProcessITextEvent;
import com.itextpdf.commons.actions.confirmations.ConfirmEvent;
import com.itextpdf.commons.utils.MapUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.LicenseFileService;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.licensefile.Limit;
import com.itextpdf.licensing.base.licensefile.LimitType;
import com.itextpdf.licensing.base.reporting.ILicenseServer;
import com.itextpdf.licensing.base.reporting.IReportingHandler;
import com.itextpdf.licensing.base.reporting.LicenseKeyReportingConfigurer;
import com.itextpdf.licensing.base.reporting.LicenseServerFactoryKeeper;
import com.itextpdf.licensing.base.reporting.LimitManager;
import com.itextpdf.licensing.base.reporting.resultprocessor.EventTypeMapperProcessor;
import com.itextpdf.licensing.base.reporting.resultprocessor.ExceededStrategiesProcessor;
import com.itextpdf.licensing.base.reporting.resultprocessor.TimeWrapperStrategiesProcessor;
import com.itextpdf.licensing.base.reporting.volume.VolumeDataCacheComparatorBased;
import com.itextpdf.licensing.base.reporting.volume.VolumeDataFactory;
import com.itextpdf.licensing.base.reporting.volume.VolumeEventDataHandler;
import com.itextpdf.licensing.base.reporting.volume.VolumeEventDataHandlerUtil;
import com.itextpdf.licensing.base.strategy.IStrategy;
import com.itextpdf.licensing.base.strategy.StrategyFactory;
import com.itextpdf.licensing.base.strategy.TimeWrapperStrategy;
import com.itextpdf.licensing.base.util.ReportedEventsSet;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReportingHandler
implements IReportingHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportingHandler.class);
    private static final ReportingHandler INSTANCE = new ReportingHandler();
    private static final long INITIAL_WAIT_TIME_FOR_REPORTING = 10000L;
    private static final long MAX_WAIT_TIME_FOR_REPORTING = 300000L;
    private static final long INITIAL_LEFT_LIMITS_OBTAINING_WAIT_TIME = 30000L;
    private static final long MAX_LEFT_LIMITS_OBTAINING_WAIT_TIME = 300000L;
    private final ExceededStrategiesProcessor exceededProcessor = new ExceededStrategiesProcessor();
    private final EventTypeMapperProcessor reportingProcessor = new EventTypeMapperProcessor();
    private final TimeWrapperStrategiesProcessor limitProcessor = new TimeWrapperStrategiesProcessor();
    private final ReportedEventsSet reportedEvents = new ReportedEventsSet();
    private final Object syncLock = new Object();
    private ServerConnector serverConnector;

    private ReportingHandler() {
    }

    static ReportingHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void updateReportingForProduct(String productName) {
        LicenseFile licenseFile = LicenseFileService.getLicenseFileForProduct(productName);
        if (licenseFile == null) {
            this.unloadLicenseFileForProduct(productName);
            return;
        }
        HashMap<String, IStrategy> tempUnavailabilityReporting = new HashMap<String, IStrategy>();
        HashMap<String, TimeWrapperStrategy> tempUnavailabilityLimit = new HashMap<String, TimeWrapperStrategy>();
        HashMap<String, IStrategy> tempExceeded = new HashMap<String, IStrategy>();
        String product = licenseFile.getProduct();
        boolean hasDefaultUnavailabilityStrategy = false;
        Limit defaultLimit = null;
        for (Map.Entry<String, Limit> entry : licenseFile.getLimits().entrySet()) {
            Limit limit = entry.getValue();
            String eventType = entry.getKey();
            IStrategy exceededStrategy = StrategyFactory.createLimitExceededStrategy(limit, product, eventType);
            IStrategy unavailabilityStrategyReporting = StrategyFactory.createEventReportingUnavailabilityStrategy(limit, product, eventType);
            TimeWrapperStrategy unavailabilityStrategyLimit = new TimeWrapperStrategy(StrategyFactory.createLimitUpdatingUnavailabilityStrategy(limit, product, eventType));
            if ("default".equals(eventType)) {
                defaultLimit = limit;
                hasDefaultUnavailabilityStrategy = defaultLimit != null && Boolean.TRUE.equals(defaultLimit.getSendEvents());
                continue;
            }
            MapUtil.putIfNotNull(tempExceeded, (Object)eventType, (Object)exceededStrategy);
            MapUtil.putIfNotNull(tempUnavailabilityReporting, (Object)eventType, (Object)unavailabilityStrategyReporting);
            MapUtil.putIfNotNull(tempUnavailabilityLimit, (Object)eventType, (Object)unavailabilityStrategyLimit);
        }
        if (!tempUnavailabilityReporting.isEmpty() && !tempUnavailabilityLimit.isEmpty() || hasDefaultUnavailabilityStrategy) {
            this.synchronizedFieldsUpdate(licenseFile, tempUnavailabilityReporting, defaultLimit, tempUnavailabilityLimit, tempExceeded);
        } else {
            this.unloadLicenseFileForProduct(productName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateReportingConfig() {
        if (this.serverConnector == null) {
            return;
        }
        Object object = this.syncLock;
        synchronized (object) {
            ServerConnector newHandlers = this.createRemoteHandlers();
            this.updateRemoteHandlers(newHandlers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportEvent(ConfirmEvent event) {
        Object object = this.syncLock;
        synchronized (object) {
            AbstractProductProcessITextEvent confirmedEvent = event.getConfirmedEvent();
            if (!this.reportedEvents.containsEvent((AbstractProductProcessITextEvent)event) && this.isReportableEvent(confirmedEvent.getProductName(), confirmedEvent.getEventType())) {
                this.serverConnector.register(confirmedEvent);
                this.reportedEvents.putEvent((AbstractProductProcessITextEvent)event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkEvent(String productName, String eventType) {
        Object object = this.syncLock;
        synchronized (object) {
            LicenseFile licenseFile = LicenseFileService.getLicenseFileForProduct(productName);
            if (licenseFile == null) {
                return;
            }
            if (this.isEventLimitCheckRedundant(licenseFile, eventType)) {
                return;
            }
            if (this.serverConnector == null) {
                return;
            }
            this.serverConnector.checkEvent(productName, eventType);
            IStrategy strategy = this.exceededProcessor.extractStrategy(productName, eventType);
            if (strategy == null) {
                return;
            }
            if (this.serverConnector.hasLeftLimit(licenseFile, eventType)) {
                strategy.onSuccess();
            } else {
                strategy.onFailure();
            }
            strategy.onProcessing();
        }
    }

    @Override
    public Map<String, Long> getRemainingEvents(LicenseFile licenseFile) {
        LimitManager limitManager;
        LimitManager limitManager2 = limitManager = this.serverConnector == null ? null : this.serverConnector.getLimitHandler();
        if (limitManager == null) {
            return new HashMap<String, Long>();
        }
        return limitManager.getRemainingEvents(licenseFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadLicenseFileForProduct(String productName) {
        Object object = this.syncLock;
        synchronized (object) {
            this.reportingProcessor.removeStrategies(productName);
            this.limitProcessor.removeStrategies(productName);
            this.exceededProcessor.removeStrategies(productName);
            this.cleanupIfNothingRegisteredLeft();
        }
    }

    private void cleanupIfNothingRegisteredLeft() {
        if (this.reportingProcessor.isEmpty() && this.limitProcessor.isEmpty()) {
            ServerConnector toDestroy = this.serverConnector;
            this.serverConnector = null;
            this.destroyRemoteHandlers(toDestroy);
            LicenseKeyReportingConfigurer.updateLicenseData(null);
        }
    }

    private boolean isReportableEvent(String productName, String eventType) {
        boolean isReportableEvent;
        LicenseFile licenseFile = LicenseFileService.getLicenseFileForProduct(productName);
        if (licenseFile == null) {
            return false;
        }
        Limit limit = ReportingHandler.getLimitFromLicenseFile(licenseFile, eventType);
        boolean bl = isReportableEvent = limit != null && limit.getSendEvents() != false;
        if (isReportableEvent && (!this.reportingProcessor.isProcessable(productName, eventType) || this.serverConnector == null)) {
            LOGGER.error("Missing entities to report the specified event");
            return false;
        }
        return isReportableEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizedFieldsUpdate(LicenseFile licenseFile, Map<String, IStrategy> tempUnavailabilityReport, Limit defaultLimit, Map<String, TimeWrapperStrategy> tempUnavailabilityLimit, Map<String, IStrategy> tempExceeded) {
        Object object = this.syncLock;
        synchronized (object) {
            LicenseKeyReportingConfigurer.updateLicenseData(licenseFile.getEventReporting());
            try {
                String productName = licenseFile.getProduct();
                this.exceededProcessor.putAllStrategiesWithDefaultLimit(productName, defaultLimit, tempExceeded);
                this.initializeRemoteHandlers();
                this.serverConnector.forceUpdateRemainingEvents();
                this.reportingProcessor.putAllStrategiesWithDefaultLimit(productName, defaultLimit, tempUnavailabilityReport);
                this.limitProcessor.putAllStrategiesWithDefaultLimit(productName, defaultLimit, tempUnavailabilityLimit);
            }
            catch (Exception e) {
                this.cleanupIfNothingRegisteredLeft();
                throw e;
            }
        }
    }

    private void initializeRemoteHandlers() {
        if (this.serverConnector == null) {
            ServerConnector handlers = this.createRemoteHandlers();
            this.updateRemoteHandlers(handlers);
        }
    }

    private void updateRemoteHandlers(ServerConnector newHandlers) {
        if (newHandlers == null) {
            return;
        }
        ServerConnector toDestroy = this.serverConnector;
        VolumeEventDataHandlerUtil.registerProcessAllShutdownHook(newHandlers.getVolumeDataHandler());
        VolumeEventDataHandlerUtil.registerTimedProcessing(newHandlers.getVolumeDataHandler());
        this.serverConnector = newHandlers;
        this.destroyRemoteHandlers(toDestroy);
    }

    private void destroyRemoteHandlers(ServerConnector toDestroy) {
        if (toDestroy != null) {
            VolumeEventDataHandlerUtil.disableShutdownHooks(toDestroy.getVolumeDataHandler());
            VolumeEventDataHandlerUtil.disableTimedProcessing(toDestroy.getVolumeDataHandler());
            toDestroy.getVolumeDataHandler().tryProcessRest();
        }
    }

    private ServerConnector createRemoteHandlers() {
        VolumeDataCacheComparatorBased cache = new VolumeDataCacheComparatorBased(new VolumeEventDataHandlerUtil.BiggerCountComparator());
        ILicenseServer server = LicenseServerFactoryKeeper.getLicenseServerFactory().obtainConfiguredLicenseServer();
        VolumeDataFactory factory = new VolumeDataFactory();
        VolumeEventDataHandler volumeDataHandler = new VolumeEventDataHandler(cache, factory, 10000L, 300000L, server, this.reportingProcessor);
        LimitManager limitManager = new LimitManager(server, 30000L, 300000L, this.limitProcessor);
        return new ServerConnector(volumeDataHandler, limitManager);
    }

    private boolean isEventLimitCheckRedundant(LicenseFile licenseFile, String eventType) {
        Limit limit = ReportingHandler.getLimitFromLicenseFile(licenseFile, eventType);
        if (limit == null || LimitType.forbidden == limit.getLimitType()) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)"Event with type \"{0}\" for product \"{1}\" is forbidden.", (Object[])new Object[]{eventType, licenseFile.getProduct()}));
        }
        return LimitType.unlimited == limit.getLimitType() || Boolean.FALSE.equals(limit.getCheckLimits());
    }

    private static Limit getLimitFromLicenseFile(LicenseFile licenseFile, String eventType) {
        if (licenseFile == null || licenseFile.getLimits() == null) {
            return null;
        }
        Limit limit = licenseFile.getLimits().get(eventType);
        if (limit == null) {
            limit = licenseFile.getLimits().get("default");
        }
        return limit;
    }

    private static class ServerConnector {
        private final VolumeEventDataHandler volumeDataHandler;
        private final LimitManager limitManager;

        ServerConnector(VolumeEventDataHandler volumeDataHandler, LimitManager limitManager) {
            this.volumeDataHandler = volumeDataHandler;
            this.limitManager = limitManager;
        }

        VolumeEventDataHandler getVolumeDataHandler() {
            return this.volumeDataHandler;
        }

        LimitManager getLimitHandler() {
            return this.limitManager;
        }

        void register(AbstractProductProcessITextEvent event) {
            this.volumeDataHandler.register(event);
        }

        void checkEvent(String productName, String eventType) {
            this.volumeDataHandler.checkEvent(productName, eventType);
        }

        boolean hasLeftLimit(LicenseFile licenseFile, String eventType) {
            return this.limitManager.hasLeftLimit(licenseFile, eventType);
        }

        void forceUpdateRemainingEvents() {
            this.limitManager.forceUpdateRemainingEvents();
        }
    }
}

