/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.itextpdf.commons.utils.MessageFormatUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtil.class);

    private JsonUtil() {
    }

    public static String serializeToString(Object value) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            objectMapper.writer((PrettyPrinter)new CustomPrettyPrinter()).writeValue((OutputStream)outputStream, value);
            return outputStream.toString(StandardCharsets.UTF_8.name());
        }
        catch (JsonProcessingException ex) {
            LOGGER.warn(MessageFormatUtil.format((String)"Unable to serialize object. Exception {0} was thrown with the message: {1}.", (Object[])new Object[]{((Object)((Object)ex)).getClass(), ex.getMessage()}));
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static String serializeToMinimalString(Object value) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            objectMapper.writer((PrettyPrinter)new MinimalPrinter()).writeValue((OutputStream)outputStream, value);
            return outputStream.toString(StandardCharsets.UTF_8.name());
        }
        catch (JsonProcessingException ex) {
            LOGGER.warn(MessageFormatUtil.format((String)"Unable to serialize object. Exception {0} was thrown with the message: {1}.", (Object[])new Object[]{((Object)((Object)ex)).getClass(), ex.getMessage()}));
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static <T> T deserializeFromString(String content, Class<T> objectType) {
        ObjectMapper objectMapper = new ObjectMapper();
        return JsonUtil.deserializeFromString(content, objectMapper.constructType(objectType));
    }

    public static <T> T deserializeFromString(String content, TypeReference<T> objectType) {
        ObjectMapper objectMapper = new ObjectMapper();
        return JsonUtil.deserializeFromString(content, objectMapper.constructType(objectType));
    }

    public static <T> T deserializeFromString(String content, JavaType objectType) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            return (T)objectMapper.readValue(content, objectType);
        }
        catch (JsonProcessingException ex) {
            LOGGER.warn(MessageFormatUtil.format((String)"Unable to deserialize string. Exception {0} was thrown with the message: {1}.", (Object[])new Object[]{((Object)((Object)ex)).getClass(), ex.getMessage()}));
            return null;
        }
    }

    private static class MinimalPrinter
    extends DefaultPrettyPrinter {
        public MinimalPrinter() {
            this._objectFieldValueSeparatorWithSpaces = ":";
            this.indentArraysWith((DefaultPrettyPrinter.Indenter)new DefaultIndenter("", ""));
            this.indentObjectsWith((DefaultPrettyPrinter.Indenter)new DefaultIndenter("", ""));
        }

        public DefaultPrettyPrinter createInstance() {
            return new MinimalPrinter();
        }
    }

    private static class CustomPrettyPrinter
    extends DefaultPrettyPrinter {
        public CustomPrettyPrinter() {
            this._objectFieldValueSeparatorWithSpaces = ": ";
            this.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE.withLinefeed("\n"));
            this.indentObjectsWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE.withLinefeed("\n"));
        }

        public DefaultPrettyPrinter createInstance() {
            return new CustomPrettyPrinter();
        }
    }
}

