/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base;

import com.itextpdf.commons.actions.EventManager;
import com.itextpdf.commons.actions.IEvent;
import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.licensing.base.CommonsVersionChecker;
import com.itextpdf.licensing.base.LicenseFileService;
import com.itextpdf.licensing.base.LicenseInfoCreator;
import com.itextpdf.licensing.base.LicenseKeyProductData;
import com.itextpdf.licensing.base.LicenseKeyRemoteVersionChecker;
import com.itextpdf.licensing.base.ProductManager;
import com.itextpdf.licensing.base.actions.LoadLicenseEvent;
import com.itextpdf.licensing.base.actions.UnloadAllLicensesEvent;
import com.itextpdf.licensing.base.actions.UnloadLicenseEvent;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.info.LicenseInfo;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.reporting.LimitsService;
import com.itextpdf.licensing.base.statistics.LicensingUsageStatisticsEvent;
import com.itextpdf.licensing.base.statistics.ProductVersionStatisticsEvent;
import com.itextpdf.licensing.base.statistics.StatisticsEventHandler;
import com.itextpdf.licensing.base.util.LicenseFileUtil;
import com.itextpdf.licensing.base.util.LicenseKeyIoUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class LicenseKey {
    private static final String OLD_LICENSE_OPEN_TAG = "<license";
    private static final String OLD_DITO_LICENSE_OPEN_TAG = "<dito-license";

    private LicenseKey() {
    }

    public static void unloadLicenses() {
        EventManager.getInstance().onEvent((IEvent)new UnloadAllLicensesEvent());
    }

    public static void unloadLicenseForProduct(String productName) {
        EventManager.getInstance().onEvent((IEvent)new UnloadLicenseEvent(productName));
    }

    public static void loadLicenseFile(File licenseFile) throws LicenseKeyException {
        if (licenseFile == null || !FileUtil.fileExists((String)licenseFile.getAbsolutePath())) {
            throw new IllegalArgumentException("License file can not be null.");
        }
        try (InputStream is = FileUtil.getInputStreamForFile((String)licenseFile.getAbsolutePath());){
            LicenseKey.loadLicenseFile(is);
        }
        catch (IOException ex) {
            throw new LicenseKeyException(ex.getMessage(), ex);
        }
    }

    public static void loadLicenseFile(InputStream licenseIs) throws LicenseKeyException {
        List<LicenseFile> licenseFiles;
        String licenseFileStr;
        if (licenseIs == null) {
            throw new IllegalArgumentException("License file can not be null.");
        }
        try {
            licenseFileStr = LicenseKeyIoUtil.convertInputStreamToString(licenseIs);
        }
        catch (Exception ex) {
            throw new LicenseKeyException(ex.getMessage(), ex);
        }
        try {
            licenseFiles = LicenseFileUtil.parseStringToLicenseFiles(licenseFileStr);
        }
        catch (Exception ex) {
            throw new LicenseKeyException(ex.getMessage(), ex);
        }
        if ((licenseFiles == null || licenseFiles.isEmpty()) && LicenseKey.isOldLicenseFormat(licenseFileStr)) {
            throw new LicenseKeyException("Looks like you are trying to load the old xml-based license. The new iText modules require updated license in json format. If you have any further questions, please contact our support team: https://itextpdf.com/support");
        }
        LicenseKey.loadListOfLicenses(licenseFiles);
    }

    public static List<LicenseInfo> getLoadedLicensesInfo() {
        List<LicenseFile> licenseFiles = LicenseFileService.getLicenseFiles();
        ArrayList<LicenseInfo> licenseInfoList = new ArrayList<LicenseInfo>(licenseFiles.size());
        for (LicenseFile file : licenseFiles) {
            licenseInfoList.add(LicenseKey.getLoadedLicenseInfo(file));
        }
        return licenseInfoList;
    }

    static void loadLicenseFile(LicenseFile licenseFile) {
        if (!ProductManager.isCoreOrCoreIndependentProduct(licenseFile) && LicenseKey.getLoadedLicenseInfo("itext-core") == null) {
            throw new LicenseKeyException("License for iText Core has not been loaded. Please make sure to load iText Core license before loading license files for add-ons.");
        }
        EventManager.getInstance().onEvent((IEvent)new LoadLicenseEvent(licenseFile));
        EventManager.getInstance().onEvent((IEvent)new LicensingUsageStatisticsEvent(LicenseKeyProductData.getInstance()));
        EventManager.getInstance().onEvent((IEvent)new ProductVersionStatisticsEvent(LicenseKeyProductData.getInstance()));
    }

    public static LicenseInfo getLoadedLicenseInfo(String productName) {
        LicenseFile licenseFile = LicenseFileService.getLicenseFileForProduct(productName);
        return LicenseKey.getLoadedLicenseInfo(licenseFile);
    }

    private static LicenseInfo getLoadedLicenseInfo(LicenseFile licenseFile) {
        if (licenseFile == null) {
            return null;
        }
        LicenseFileService.tryToLoadUpToDateLicenseFile(licenseFile);
        LicenseFile actualLicenseFile = LicenseFileService.getLicenseFileForProduct(licenseFile.getProduct());
        Map<String, Long> remainingLimits = LimitsService.getRemainingEventsLimit(actualLicenseFile);
        return LicenseInfoCreator.createLicenseInfo(actualLicenseFile, remainingLimits);
    }

    private static void loadListOfLicenses(List<LicenseFile> licenseFiles) throws LicenseKeyException {
        if (licenseFiles == null || licenseFiles.isEmpty()) {
            throw new LicenseKeyException("License file was corrupted.");
        }
        for (LicenseFile licenseFile : licenseFiles) {
            if (!ProductManager.isCoreOrCoreIndependentProduct(licenseFile)) continue;
            LicenseKey.loadLicenseFile(licenseFile);
        }
        for (LicenseFile licenseFile : licenseFiles) {
            if (ProductManager.isCoreOrCoreIndependentProduct(licenseFile)) continue;
            LicenseKey.loadLicenseFile(licenseFile);
        }
    }

    private static boolean isOldLicenseFormat(String licenseFileStr) {
        return licenseFileStr.contains(OLD_LICENSE_OPEN_TAG) || licenseFileStr.contains(OLD_DITO_LICENSE_OPEN_TAG);
    }

    static {
        CommonsVersionChecker.checkCommonsVersion();
        try {
            LicenseKeyRemoteVersionChecker.checkLicenseKeyRemoteVersion();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        ProductManager.registerWhitelistedNamespaces();
        ProductManager.registerProductsContext();
        StatisticsEventHandler.register();
    }
}

