/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.storage;

import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.reporting.AwsResourcesCreator;
import com.itextpdf.licensing.base.storage.ILicenseFileStorageClient;
import com.itextpdf.licensing.base.util.JsonUtil;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayClient;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RemoteLicenseFileStorageClient
implements ILicenseFileStorageClient {
    private static final int HTTP_OK_STATUS = 200;
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteLicenseFileStorageClient.class);
    private static final String AWS_API_LICENSE_UPDATE_HOST = "sdk-login.licensing.itextpdf.com";
    private static final String AWS_API_LICENSE_UPDATE_PATH_PATH = "/v1/license-update";
    private final ApiGatewayClient updateLicenseRequestClient = AwsResourcesCreator.createApiGatewayClientWithoutAuth("sdk-login.licensing.itextpdf.com", "/v1/license-update");

    RemoteLicenseFileStorageClient() {
    }

    @Override
    public List<LicenseFile> getLicenseFilesFromStorage(LicenseFile sourceLicenseFile) {
        String jsonRequestBody = JsonUtil.serializeToMinimalString(sourceLicenseFile);
        ApiGatewayResponse response = null;
        try {
            response = this.updateLicenseRequestClient.makePostRequest(jsonRequestBody);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (response == null || response.getStatus() != 200 || response.getBody() == null) {
            LOGGER.info("Exception during http request to license file remote storage.");
            return Collections.emptyList();
        }
        return Arrays.asList((Object[])JsonUtil.deserializeFromString(response.getBody(), LicenseFile[].class));
    }
}

