/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.info;

import com.itextpdf.commons.utils.MapUtil;
import com.itextpdf.licensing.base.info.LimitInfo;
import java.util.Map;

public class EventsLimitInfo {
    private final Map<String, LimitInfo> eventLimits;
    private final LimitInfo defaultLimit;

    public EventsLimitInfo(LimitInfo defaultLimit, Map<String, LimitInfo> eventLimits) {
        this.defaultLimit = defaultLimit;
        this.eventLimits = eventLimits;
    }

    public LimitInfo getDefaultLimit() {
        return this.defaultLimit;
    }

    public Map<String, LimitInfo> getEventsLimitInfo() {
        return this.eventLimits;
    }

    public LimitInfo getEventLimit(String eventType) {
        if (eventType != null && this.eventLimits.containsKey(eventType)) {
            return this.eventLimits.get(eventType);
        }
        return this.getDefaultLimit();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventsLimitInfo that = (EventsLimitInfo)o;
        if (!MapUtil.equals(this.eventLimits, that.eventLimits)) {
            return false;
        }
        return this.defaultLimit != null ? this.defaultLimit.equals(that.defaultLimit) : that.defaultLimit == null;
    }

    public int hashCode() {
        int result = this.eventLimits != null ? MapUtil.getHashCode(this.eventLimits) : 0;
        result = 31 * result + (this.defaultLimit != null ? this.defaultLimit.hashCode() : 0);
        return result;
    }
}

